/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v105.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v105.security.model.CertificateError;
import org.openqa.selenium.devtools.v105.security.model.CertificateErrorAction;
import org.openqa.selenium.devtools.v105.security.model.SecurityStateChanged;
import org.openqa.selenium.devtools.v105.security.model.VisibleSecurityState;

public class Security {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Security.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Security.enable", (Map)params.build());
    }

    @Beta
    public static Command<Void> setIgnoreCertificateErrors(Boolean ignore) {
        Objects.requireNonNull(ignore, "ignore is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ignore", (Object)ignore);
        return new Command("Security.setIgnoreCertificateErrors", (Map)params.build());
    }

    @Deprecated
    public static Command<Void> handleCertificateError(Integer eventId, CertificateErrorAction action) {
        Objects.requireNonNull(eventId, "eventId is required");
        Objects.requireNonNull(action, "action is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventId", (Object)eventId);
        params.put((Object)"action", (Object)action);
        return new Command("Security.handleCertificateError", (Map)params.build());
    }

    @Deprecated
    public static Command<Void> setOverrideCertificateErrors(Boolean override) {
        Objects.requireNonNull(override, "override is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"override", (Object)override);
        return new Command("Security.setOverrideCertificateErrors", (Map)params.build());
    }

    public static Event<CertificateError> certificateError() {
        return new Event("Security.certificateError", input -> (CertificateError)input.read(CertificateError.class));
    }

    public static Event<VisibleSecurityState> visibleSecurityStateChanged() {
        return new Event("Security.visibleSecurityStateChanged", ConverterFunctions.map((String)"visibleSecurityState", VisibleSecurityState.class));
    }

    public static Event<SecurityStateChanged> securityStateChanged() {
        return new Event("Security.securityStateChanged", input -> (SecurityStateChanged)input.read(SecurityStateChanged.class));
    }
}

