package org.openqa.selenium.devtools.v105.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS Supports at-rule descriptor.
 */
@org.openqa.selenium.Beta()
public class CSSSupports {

    private final java.lang.String text;

    private final java.lang.Boolean active;

    private final java.util.Optional<org.openqa.selenium.devtools.v105.css.model.SourceRange> range;

    private final java.util.Optional<org.openqa.selenium.devtools.v105.css.model.StyleSheetId> styleSheetId;

    public CSSSupports(java.lang.String text, java.lang.Boolean active, java.util.Optional<org.openqa.selenium.devtools.v105.css.model.SourceRange> range, java.util.Optional<org.openqa.selenium.devtools.v105.css.model.StyleSheetId> styleSheetId) {
        this.text = java.util.Objects.requireNonNull(text, "text is required");
        this.active = java.util.Objects.requireNonNull(active, "active is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
    }

    /**
     * Supports rule text.
     */
    public java.lang.String getText() {
        return text;
    }

    /**
     * Whether the supports condition is satisfied.
     */
    public java.lang.Boolean getActive() {
        return active;
    }

    /**
     * The associated rule header range in the enclosing stylesheet (if
     * available).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v105.css.model.SourceRange> getRange() {
        return range;
    }

    /**
     * Identifier of the stylesheet containing this object (if exists).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v105.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    private static CSSSupports fromJson(JsonInput input) {
        java.lang.String text = null;
        java.lang.Boolean active = false;
        java.util.Optional<org.openqa.selenium.devtools.v105.css.model.SourceRange> range = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v105.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "text":
                    text = input.nextString();
                    break;
                case "active":
                    active = input.nextBoolean();
                    break;
                case "range":
                    range = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v105.css.model.SourceRange.class));
                    break;
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v105.css.model.StyleSheetId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSSupports(text, active, range, styleSheetId);
    }
}
