/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v102.emulation.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v102.emulation.model.UserAgentBrandVersion;
import org.openqa.selenium.json.JsonInput;

@Beta
public class UserAgentMetadata {
    private final Optional<List<UserAgentBrandVersion>> brands;
    private final Optional<List<UserAgentBrandVersion>> fullVersionList;
    private final Optional<String> fullVersion;
    private final String platform;
    private final String platformVersion;
    private final String architecture;
    private final String model;
    private final Boolean mobile;

    public UserAgentMetadata(Optional<List<UserAgentBrandVersion>> brands, Optional<List<UserAgentBrandVersion>> fullVersionList, Optional<String> fullVersion, String platform, String platformVersion, String architecture, String model, Boolean mobile) {
        this.brands = brands;
        this.fullVersionList = fullVersionList;
        this.fullVersion = fullVersion;
        this.platform = Objects.requireNonNull(platform, "platform is required");
        this.platformVersion = Objects.requireNonNull(platformVersion, "platformVersion is required");
        this.architecture = Objects.requireNonNull(architecture, "architecture is required");
        this.model = Objects.requireNonNull(model, "model is required");
        this.mobile = Objects.requireNonNull(mobile, "mobile is required");
    }

    public Optional<List<UserAgentBrandVersion>> getBrands() {
        return this.brands;
    }

    public Optional<List<UserAgentBrandVersion>> getFullVersionList() {
        return this.fullVersionList;
    }

    @Deprecated
    public Optional<String> getFullVersion() {
        return this.fullVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getModel() {
        return this.model;
    }

    public Boolean getMobile() {
        return this.mobile;
    }

    private static UserAgentMetadata fromJson(JsonInput input) {
        Optional<List<UserAgentBrandVersion>> brands = Optional.empty();
        Optional<List<UserAgentBrandVersion>> fullVersionList = Optional.empty();
        Optional<String> fullVersion = Optional.empty();
        String platform = null;
        String platformVersion = null;
        String architecture = null;
        String model = null;
        Boolean mobile = false;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "brands": {
                    brands = Optional.ofNullable((List)input.read(new TypeToken<List<UserAgentBrandVersion>>(){}.getType()));
                    continue block20;
                }
                case "fullVersionList": {
                    fullVersionList = Optional.ofNullable((List)input.read(new TypeToken<List<UserAgentBrandVersion>>(){}.getType()));
                    continue block20;
                }
                case "fullVersion": {
                    fullVersion = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "platform": {
                    platform = input.nextString();
                    continue block20;
                }
                case "platformVersion": {
                    platformVersion = input.nextString();
                    continue block20;
                }
                case "architecture": {
                    architecture = input.nextString();
                    continue block20;
                }
                case "model": {
                    model = input.nextString();
                    continue block20;
                }
                case "mobile": {
                    mobile = input.nextBoolean();
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new UserAgentMetadata(brands, fullVersionList, fullVersion, platform, platformVersion, architecture, model, mobile);
    }
}

