package org.openqa.selenium.devtools.v102.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Font families collection for a script.
 */
@org.openqa.selenium.Beta()
public class ScriptFontFamilies {

    private final java.lang.String script;

    private final org.openqa.selenium.devtools.v102.page.model.FontFamilies fontFamilies;

    public ScriptFontFamilies(java.lang.String script, org.openqa.selenium.devtools.v102.page.model.FontFamilies fontFamilies) {
        this.script = java.util.Objects.requireNonNull(script, "script is required");
        this.fontFamilies = java.util.Objects.requireNonNull(fontFamilies, "fontFamilies is required");
    }

    /**
     * Name of the script which these font families are defined for.
     */
    public java.lang.String getScript() {
        return script;
    }

    /**
     * Generic font families collection for the script.
     */
    public org.openqa.selenium.devtools.v102.page.model.FontFamilies getFontFamilies() {
        return fontFamilies;
    }

    private static ScriptFontFamilies fromJson(JsonInput input) {
        java.lang.String script = null;
        org.openqa.selenium.devtools.v102.page.model.FontFamilies fontFamilies = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "script":
                    script = input.nextString();
                    break;
                case "fontFamilies":
                    fontFamilies = input.read(org.openqa.selenium.devtools.v102.page.model.FontFamilies.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScriptFontFamilies(script, fontFamilies);
    }
}
