/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v101.console.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class ConsoleMessage {
    private final Source source;
    private final Level level;
    private final String text;
    private final Optional<String> url;
    private final Optional<Integer> line;
    private final Optional<Integer> column;

    public ConsoleMessage(Source source, Level level, String text, Optional<String> url, Optional<Integer> line, Optional<Integer> column) {
        this.source = Objects.requireNonNull(source, "source is required");
        this.level = Objects.requireNonNull(level, "level is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.url = url;
        this.line = line;
        this.column = column;
    }

    public Source getSource() {
        return this.source;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<Integer> getLine() {
        return this.line;
    }

    public Optional<Integer> getColumn() {
        return this.column;
    }

    private static ConsoleMessage fromJson(JsonInput input) {
        Source source = null;
        Level level = null;
        String text = null;
        Optional<String> url = Optional.empty();
        Optional<Integer> line = Optional.empty();
        Optional<Integer> column = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "source": {
                    source = Source.fromString(input.nextString());
                    continue block16;
                }
                case "level": {
                    level = Level.fromString(input.nextString());
                    continue block16;
                }
                case "text": {
                    text = input.nextString();
                    continue block16;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "line": {
                    line = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
                case "column": {
                    column = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleMessage(source, level, text, url, line, column);
    }

    public static enum Level {
        LOG("log"),
        WARNING("warning"),
        ERROR("error"),
        DEBUG("debug"),
        INFO("info");

        private String value;

        private Level(String value) {
            this.value = value;
        }

        public static Level fromString(String s) {
            return Arrays.stream(Level.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Level "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Level fromJson(JsonInput input) {
            return Level.fromString(input.nextString());
        }
    }

    public static enum Source {
        XML("xml"),
        JAVASCRIPT("javascript"),
        NETWORK("network"),
        CONSOLE_API("console-api"),
        STORAGE("storage"),
        APPCACHE("appcache"),
        RENDERING("rendering"),
        SECURITY("security"),
        OTHER("other"),
        DEPRECATION("deprecation"),
        WORKER("worker");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

