package org.openqa.selenium.devtools.v101.security.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class SafetyTipInfo {

    private final org.openqa.selenium.devtools.v101.security.model.SafetyTipStatus safetyTipStatus;

    private final java.util.Optional<java.lang.String> safeUrl;

    public SafetyTipInfo(org.openqa.selenium.devtools.v101.security.model.SafetyTipStatus safetyTipStatus, java.util.Optional<java.lang.String> safeUrl) {
        this.safetyTipStatus = java.util.Objects.requireNonNull(safetyTipStatus, "safetyTipStatus is required");
        this.safeUrl = safeUrl;
    }

    /**
     * Describes whether the page triggers any safety tips or reputation warnings. Default is unknown.
     */
    public org.openqa.selenium.devtools.v101.security.model.SafetyTipStatus getSafetyTipStatus() {
        return safetyTipStatus;
    }

    /**
     * The URL the safety tip suggested ("Did you mean?"). Only filled in for lookalike matches.
     */
    public java.util.Optional<java.lang.String> getSafeUrl() {
        return safeUrl;
    }

    private static SafetyTipInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v101.security.model.SafetyTipStatus safetyTipStatus = null;
        java.util.Optional<java.lang.String> safeUrl = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "safetyTipStatus":
                    safetyTipStatus = input.read(org.openqa.selenium.devtools.v101.security.model.SafetyTipStatus.class);
                    break;
                case "safeUrl":
                    safeUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SafetyTipInfo(safetyTipStatus, safeUrl);
    }
}
