/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v101.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v101.page.model.PermissionsPolicyBlockLocator;
import org.openqa.selenium.devtools.v101.page.model.PermissionsPolicyFeature;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PermissionsPolicyFeatureState {
    private final PermissionsPolicyFeature feature;
    private final Boolean allowed;
    private final Optional<PermissionsPolicyBlockLocator> locator;

    public PermissionsPolicyFeatureState(PermissionsPolicyFeature feature, Boolean allowed, Optional<PermissionsPolicyBlockLocator> locator) {
        this.feature = Objects.requireNonNull(feature, "feature is required");
        this.allowed = Objects.requireNonNull(allowed, "allowed is required");
        this.locator = locator;
    }

    public PermissionsPolicyFeature getFeature() {
        return this.feature;
    }

    public Boolean getAllowed() {
        return this.allowed;
    }

    public Optional<PermissionsPolicyBlockLocator> getLocator() {
        return this.locator;
    }

    private static PermissionsPolicyFeatureState fromJson(JsonInput input) {
        PermissionsPolicyFeature feature = null;
        Boolean allowed = false;
        Optional<PermissionsPolicyBlockLocator> locator = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "feature": {
                    feature = (PermissionsPolicyFeature)((Object)input.read(PermissionsPolicyFeature.class));
                    continue block10;
                }
                case "allowed": {
                    allowed = input.nextBoolean();
                    continue block10;
                }
                case "locator": {
                    locator = Optional.ofNullable((PermissionsPolicyBlockLocator)input.read(PermissionsPolicyBlockLocator.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PermissionsPolicyFeatureState(feature, allowed, locator);
    }
}

