/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.Console;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Log;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ChromeDevToolsLocator {
    private static final Json JSON = new Json();

    ChromeDevToolsLocator() {
    }

    public static Optional<Connection> getChromeConnector(HttpClient.Factory clientFactory, Capabilities caps) {
        Object raw = caps.getCapability("goog:chromeOptions");
        if (!(raw instanceof Map)) {
            return Optional.empty();
        }
        if (!((raw = ((Map)raw).get("debuggerAddress")) instanceof String)) {
            return Optional.empty();
        }
        int index = ((String)raw).lastIndexOf(":");
        if (index == -1 || index == ((String)raw).length() - 1) {
            return Optional.empty();
        }
        try {
            URL url = new URL(String.format("http://%s", raw));
            HttpClient client = clientFactory.createClient(url);
            HttpResponse res = client.execute(new HttpRequest(HttpMethod.GET, "/json/version"));
            if (res.getStatus() != 200) {
                return Optional.empty();
            }
            Map versionData = (Map)JSON.toType(res.getContentString(), Json.MAP_TYPE);
            raw = versionData.get("webSocketDebuggerUrl");
            if (!(raw instanceof String)) {
                return Optional.empty();
            }
            String debuggerUrl = (String)raw;
            return Optional.of(new Connection(client, debuggerUrl));
        }
        catch (IOException | JsonException e) {
            return Optional.empty();
        }
    }

    public static void main(String[] args) throws Exception {
        ChromeDriver driver = new ChromeDriver();
        DevTools devTools = driver.getDevTools();
        devTools.createSession();
        devTools.send(Log.enable());
        devTools.addListener(Log.entryAdded(), entry -> System.out.println(entry.asSeleniumLogEntry()));
        devTools.send(Console.enable());
        devTools.addListener(Console.messageAdded(), System.out::println);
        driver.get("http://www.google.com");
        driver.executeScript("console.log('Hello, World!');", new Object[0]);
        Thread.sleep(2000L);
        driver.quit();
    }
}

