/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeBinary;
import org.openqa.selenium.chrome.ChromeNotRunningException;
import org.openqa.selenium.chrome.FatalChromeException;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.internal.SocketLock;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;

public class ChromeCommandExecutor
implements CommandExecutor {
    private static final Logger LOG = Logger.getLogger(ChromeCommandExecutor.class.getName());
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMicros(120L);
    private static final int MAX_START_RETRIES = 5;
    private static final String[] ELEMENT_ID_ARG = new String[]{"id"};
    private static final String[] NO_ARGS = new String[0];
    private ChromeBinary binary;
    private long timeout = DEFAULT_TIMEOUT;
    private volatile boolean listen = false;
    ListeningThread listeningThread;
    private Map<String, String[]> commands;

    public ChromeCommandExecutor(ChromeBinary binary) {
        this.binary = binary;
        this.commands = ImmutableMap.builder().put((Object)"close", (Object)NO_ARGS).put((Object)"quit", (Object)NO_ARGS).put((Object)"get", (Object)new String[]{"url"}).put((Object)"goBack", (Object)NO_ARGS).put((Object)"goForward", (Object)NO_ARGS).put((Object)"refresh", (Object)NO_ARGS).put((Object)"addCookie", (Object)new String[]{"cookie"}).put((Object)"getCookies", (Object)NO_ARGS).put((Object)"getCookie", (Object)new String[]{"name"}).put((Object)"deleteAllCookies", (Object)NO_ARGS).put((Object)"deleteCookie", (Object)new String[]{"name"}).put((Object)"findElement", (Object)new String[]{"using", "value"}).put((Object)"findElements", (Object)new String[]{"using", "value"}).put((Object)"findChildElement", (Object)new String[]{"id", "using", "value"}).put((Object)"findChildElements", (Object)new String[]{"id", "using", "value"}).put((Object)"clearElement", (Object)ELEMENT_ID_ARG).put((Object)"clickElement", (Object)ELEMENT_ID_ARG).put((Object)"hoverOverElement", (Object)ELEMENT_ID_ARG).put((Object)"sendKeysToElement", (Object)new String[]{"id", "value"}).put((Object)"submitElement", (Object)ELEMENT_ID_ARG).put((Object)"toggleElement", (Object)ELEMENT_ID_ARG).put((Object)"getElementAttribute", (Object)new String[]{"id", "name"}).put((Object)"getElementLocationOnceScrolledIntoView", (Object)ELEMENT_ID_ARG).put((Object)"getElementLocation", (Object)ELEMENT_ID_ARG).put((Object)"getElementSize", (Object)ELEMENT_ID_ARG).put((Object)"getElementTagName", (Object)ELEMENT_ID_ARG).put((Object)"getElementText", (Object)ELEMENT_ID_ARG).put((Object)"getElementValue", (Object)ELEMENT_ID_ARG).put((Object)"getElementValueOfCssProperty", (Object)new String[]{"id", "propertyName"}).put((Object)"isElementDisplayed", (Object)ELEMENT_ID_ARG).put((Object)"isElementEnabled", (Object)ELEMENT_ID_ARG).put((Object)"isElementSelected", (Object)ELEMENT_ID_ARG).put((Object)"setElementSelected", (Object)ELEMENT_ID_ARG).put((Object)"getActiveElement", (Object)NO_ARGS).put((Object)"switchToFrame", (Object)new String[]{"id"}).put((Object)"getCurrentWindowHandle", (Object)NO_ARGS).put((Object)"getWindowHandles", (Object)NO_ARGS).put((Object)"switchToWindow", (Object)new String[]{"name"}).put((Object)"getCurrentUrl", (Object)NO_ARGS).put((Object)"getPageSource", (Object)NO_ARGS).put((Object)"getTitle", (Object)NO_ARGS).put((Object)"executeScript", (Object)new String[]{"script", "args"}).put((Object)"executeAsyncScript", (Object)new String[]{"script", "args"}).put((Object)"screenshot", (Object)NO_ARGS).put((Object)"implicitlyWait", (Object)new String[]{"ms"}).put((Object)"setScriptTimeout", (Object)new String[]{"ms"}).build();
    }

    public ChromeBinary getBinary() {
        return this.binary;
    }

    boolean hasClient() {
        return this.listeningThread != null && this.listeningThread.hasClient;
    }

    public int getPort() {
        return this.listeningThread == null ? -1 : this.listeningThread.serverSocket.getLocalPort();
    }

    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            return this.createCannedNewSessionResponse();
        }
        this.sendCommand(command);
        return this.handleResponse();
    }

    private Response createCannedNewSessionResponse() {
        Map capabilitiesMap;
        Response response = new Response();
        response.setSessionId("[no session]");
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        capabilities.setJavascriptEnabled(true);
        try {
            capabilitiesMap = (Map)new JsonToBeanConverter().convert(Map.class, (Object)new BeanToJsonConverter().convert((Object)capabilities));
        }
        catch (WebDriverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        response.setValue((Object)capabilitiesMap);
        return response;
    }

    private void sendCommand(Command command) throws IOException {
        if (!this.hasClient()) {
            throw new IllegalStateException("Cannot execute command without a client");
        }
        String commandStringToSend = this.fillArgs(command);
        byte[] data = this.fillTwoHundredWithJson(commandStringToSend);
        Socket oldestSocket = this.getOldestSocket();
        this.writeAndFlushToSocket(data, oldestSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndFlushToSocket(byte[] data, Socket socket) throws IOException {
        try {
            socket.getOutputStream().write(data);
            socket.getOutputStream().flush();
        }
        finally {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
            socket.close();
            this.listeningThread.sockets.remove(socket);
        }
    }

    String fillArgs(Command command) {
        JSONObject json;
        String[] parameterNames = this.commands.get(command.getName());
        if (parameterNames.length != command.getParameters().size()) {
            throw new WebDriverException((Throwable)new IllegalArgumentException("Did not supply the expected number of parameters"));
        }
        try {
            String rawJson = new BeanToJsonConverter().convert((Object)command.getParameters());
            json = new JSONObject(rawJson);
            json.put("request", (Object)command.getName());
            for (String parameterName : parameterNames) {
                if (command.getParameters().containsKey(parameterName)) continue;
                throw new WebDriverException("Missing required parameter \"" + parameterName + "\"");
            }
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        return json.toString();
    }

    private byte[] fillTwoHundredWithJson(String message) {
        return this.fillTwoHundred(message, "application/json; charset=UTF-8");
    }

    private byte[] fillTwoHundred(String message, String contentType) {
        try {
            String httpMessage = "HTTP/1.1 200 OK\r\nContent-Length: " + message.getBytes("UTF-8").length + "\r\nContent-Type: " + contentType + "\r\n\r\n" + message;
            return httpMessage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebDriverException("Your environment doesn't support UTF-8");
        }
    }

    private Response handleResponse() throws IOException {
        String line;
        Socket socket = this.getOldestSocket();
        StringBuilder resultBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        boolean hasSeenDoubleCRLF = false;
        while ((line = reader.readLine()) != null && !line.equals("EOResponse")) {
            if (hasSeenDoubleCRLF) {
                if (resultBuilder.length() > 0) {
                    resultBuilder.append("\n");
                }
                resultBuilder.append(line);
            }
            if (!line.equals("")) continue;
            hasSeenDoubleCRLF = true;
        }
        try {
            return (Response)new JsonToBeanConverter().convert(Response.class, (Object)resultBuilder.toString());
        }
        catch (WebDriverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Socket getOldestSocket() {
        Socket socket;
        while ((socket = (Socket)this.listeningThread.sockets.peek()) == null) {
            if (!this.binary.isRunning()) {
                throw new ChromeNotRunningException("Chrome is no longer running!");
            }
            Thread.yield();
        }
        return socket;
    }

    public void start() {
        Lock lock = this.newLock();
        lock.lock(DEFAULT_TIMEOUT);
        try {
            int port = this.binary.getPort();
            if (port == 0) {
                port = this.determineNextFreePort(7055);
            }
            this.binary.setPort(port);
            for (int retries = 5; !this.hasClient() && retries > 0; --retries) {
                this.stop();
                this.startListening();
                this.binary.start();
                this.binary.incrementBackoffBy(1);
            }
            this.binary.incrementBackoffBy(-1);
            if (!this.hasClient()) {
                this.stop();
                throw new FatalChromeException("Cannot create chrome driver");
            }
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineNextFreePort(int port) throws IOException {
        int newport;
        for (newport = port; newport < port + 200; ++newport) {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress("localhost", newport);
            try {
                socket.bind(address);
                int n = newport;
                return n;
            }
            catch (BindException e) {
                continue;
            }
            finally {
                socket.close();
            }
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }

    protected Lock newLock() {
        return new SocketLock();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void startListening() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.binary.getPort());
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.listen = true;
        this.listeningThread = new ListeningThread(serverSocket);
        this.listeningThread.start();
    }

    public void stop() {
        this.binary.kill();
        this.listen = false;
        if (this.listeningThread != null) {
            this.listeningThread.stopListening();
            this.listeningThread = null;
        }
    }

    private class ListeningThread
    extends Thread {
        private boolean isListening = false;
        private Queue<Socket> sockets = new ConcurrentLinkedQueue<Socket>();
        private ServerSocket serverSocket;
        private volatile boolean hasClient = false;

        ListeningThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void run() {
            if (!this.isListening) {
                this.listen();
            }
        }

        public void listen() {
            this.isListening = true;
            try {
                while (ChromeCommandExecutor.this.listen && !this.serverSocket.isClosed()) {
                    Socket acceptedSocket = this.serverSocket.accept();
                    acceptedSocket.setSoLinger(true, 10);
                    int r = acceptedSocket.getInputStream().read();
                    if (r != 71) {
                        this.sockets.add(acceptedSocket);
                        this.hasClient = true;
                        continue;
                    }
                    this.respondWithHoldingPage(acceptedSocket);
                }
            }
            catch (SocketException e) {
            }
            catch (IOException e) {
                this.isListening = false;
                throw new WebDriverException((Throwable)e);
            }
        }

        private void respondWithHoldingPage(Socket socket) throws IOException {
            byte[] data = ChromeCommandExecutor.this.fillTwoHundred("<html><head><script type='text/javascript'>if (window.location.search == '') { setTimeout(\"window.location = window.location.href + '?reloaded'\", 5000); }</script></head><body><p>ChromeDriver server started and connected.  Please leave this tab open.</p></body></html>", "Content-Type: text/html");
            ChromeCommandExecutor.this.writeAndFlushToSocket(data, socket);
        }

        public void stopListening() {
            try {
                this.closeCurrentSockets();
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
            finally {
                try {
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                        while (!this.serverSocket.isClosed()) {
                            Thread.yield();
                        }
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "I/O error while closing the server socket", e);
                }
            }
        }

        private void closeCurrentSockets() {
            for (Socket socket : this.sockets) {
                try {
                    socket.close();
                    this.sockets.remove(socket);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

