/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.XPathLookupException;
import org.openqa.selenium.chrome.ChromeResponse;
import org.openqa.selenium.chrome.ChromeWebElement;
import org.openqa.selenium.chrome.FatalChromeException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DriverCommand;

public class ChromeCommandExecutor {
    private static final String[] ELEMENT_ID_ARG = new String[]{"elementId"};
    private static final String[] NO_ARGS = new String[0];
    private final ServerSocket serverSocket;
    private volatile boolean listen = false;
    private boolean hadClient = false;
    private boolean hasClient = false;
    ListeningThread listeningThread;
    private Map<DriverCommand, String[]> commands = ImmutableMap.builder().put((Object)DriverCommand.CLOSE, (Object)NO_ARGS).put((Object)DriverCommand.QUIT, (Object)NO_ARGS).put((Object)DriverCommand.GET, (Object)new String[]{"url"}).put((Object)DriverCommand.GO_BACK, (Object)NO_ARGS).put((Object)DriverCommand.GO_FORWARD, (Object)NO_ARGS).put((Object)DriverCommand.REFRESH, (Object)NO_ARGS).put((Object)DriverCommand.ADD_COOKIE, (Object)new String[]{"cookie"}).put((Object)DriverCommand.GET_ALL_COOKIES, (Object)NO_ARGS).put((Object)DriverCommand.GET_COOKIE, (Object)new String[]{"name"}).put((Object)DriverCommand.DELETE_ALL_COOKIES, (Object)NO_ARGS).put((Object)DriverCommand.DELETE_COOKIE, (Object)new String[]{"name"}).put((Object)DriverCommand.FIND_ELEMENT, (Object)new String[]{"using", "value"}).put((Object)DriverCommand.FIND_ELEMENTS, (Object)new String[]{"using", "value"}).put((Object)DriverCommand.FIND_CHILD_ELEMENT, (Object)new String[]{"id", "using", "value"}).put((Object)DriverCommand.FIND_CHILD_ELEMENTS, (Object)new String[]{"id", "using", "value"}).put((Object)DriverCommand.CLEAR_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.CLICK_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.HOVER_OVER_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.SEND_KEYS_TO_ELEMENT, (Object)new String[]{"elementId", "keys"}).put((Object)DriverCommand.SUBMIT_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.TOGGLE_ELEMENT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_ATTRIBUTE, (Object)new String[]{"elementId", "attribute"}).put((Object)DriverCommand.GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_LOCATION, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_SIZE, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_TAG_NAME, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_TEXT, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_VALUE, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ELEMENT_VALUE_OF_CSS_PROPERTY, (Object)new String[]{"elementId", "css"}).put((Object)DriverCommand.IS_ELEMENT_DISPLAYED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.IS_ELEMENT_ENABLED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.IS_ELEMENT_SELECTED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.SET_ELEMENT_SELECTED, (Object)ELEMENT_ID_ARG).put((Object)DriverCommand.GET_ACTIVE_ELEMENT, (Object)NO_ARGS).put((Object)DriverCommand.SWITCH_TO_FRAME_BY_INDEX, (Object)new String[]{"index"}).put((Object)DriverCommand.SWITCH_TO_FRAME_BY_NAME, (Object)new String[]{"name"}).put((Object)DriverCommand.SWITCH_TO_DEFAULT_CONTENT, (Object)NO_ARGS).put((Object)DriverCommand.GET_CURRENT_WINDOW_HANDLE, (Object)NO_ARGS).put((Object)DriverCommand.GET_WINDOW_HANDLES, (Object)NO_ARGS).put((Object)DriverCommand.SWITCH_TO_WINDOW, (Object)new String[]{"windowName"}).put((Object)DriverCommand.GET_CURRENT_URL, (Object)NO_ARGS).put((Object)DriverCommand.GET_PAGE_SOURCE, (Object)NO_ARGS).put((Object)DriverCommand.GET_TITLE, (Object)NO_ARGS).put((Object)DriverCommand.EXECUTE_SCRIPT, (Object)new String[]{"script", "args"}).put((Object)DriverCommand.SCREENSHOT, (Object)NO_ARGS).build();

    public ChromeCommandExecutor(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.listen = true;
        this.listeningThread = new ListeningThread(this.serverSocket);
        this.listeningThread.start();
    }

    boolean hasClient() {
        return this.hasClient;
    }

    public ChromeResponse execute(Command command) throws IOException {
        this.sendCommand(command);
        return this.handleResponse(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(Command command) throws IOException {
        Socket socket;
        while ((socket = (Socket)this.listeningThread.sockets.peek()) == null) {
            if (this.hadClient && !this.hasClient) {
                throw new IllegalStateException("Cannot execute command without a client");
            }
            Thread.yield();
        }
        try {
            String commandStringToSend = this.fillArgs(command);
            socket.getOutputStream().write(this.fillTwoHundredWithJson(commandStringToSend));
            socket.getOutputStream().flush();
        }
        finally {
            socket.close();
            this.listeningThread.sockets.remove(socket);
        }
    }

    String fillArgs(Command command) {
        String[] parameterNames = this.commands.get(command.getName());
        JSONObject json = new JSONObject();
        if (parameterNames.length != command.getParameters().length) {
            throw new WebDriverException((Throwable)new IllegalArgumentException("Did not supply the expected number of parameters"));
        }
        try {
            json.put("request", (Object)command.getName());
            for (int i = 0; i < parameterNames.length; ++i) {
                boolean isArgs = DriverCommand.EXECUTE_SCRIPT.equals((Object)command.getName()) && "args".equals(parameterNames[i]);
                json.put(parameterNames[i], this.convertToJsonObject(command.getParameters()[i], isArgs));
            }
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        return json.toString();
    }

    Object convertToJsonObject(Object object, boolean wrapArgs) throws JSONException {
        if (object.getClass().isArray()) {
            JSONArray array = new JSONArray();
            for (Object o : (Object[])object) {
                if (wrapArgs) {
                    array.put(this.wrapArgumentForScriptExecution(o));
                    continue;
                }
                array.put(o);
            }
            return array;
        }
        if (object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            HashMap<String, Object> cookieMap = new HashMap<String, Object>();
            cookieMap.put("name", cookie.getName());
            cookieMap.put("value", cookie.getValue());
            cookieMap.put("domain", cookie.getDomain());
            cookieMap.put("path", cookie.getPath());
            cookieMap.put("secure", cookie.isSecure());
            cookieMap.put("expiry", cookie.getExpiry());
            return new JSONObject(cookieMap);
        }
        if (object instanceof ChromeWebElement) {
            return ((ChromeWebElement)object).getElementId();
        }
        return object;
    }

    private byte[] fillTwoHundredWithJson(String message) {
        return this.fillTwoHundred(message, "application/json; charset=UTF-8");
    }

    private byte[] fillTwoHundred(String message, String contentType) {
        try {
            String httpMessage = "HTTP/1.1 200 OK\r\nContent-Length: " + message.getBytes("UTF-8").length + "\r\nContent-Type: " + contentType + "\r\n\r\n" + message;
            return httpMessage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebDriverException("Your environment doesn't support UTF-8");
        }
    }

    private ChromeResponse handleResponse(Command command) throws IOException {
        String line;
        Socket socket;
        while ((socket = (Socket)this.listeningThread.sockets.peek()) == null) {
            Thread.yield();
        }
        StringBuilder resultBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        boolean hasSeenDoubleCRLF = false;
        while ((line = reader.readLine()) != null && !line.equals("EOResponse")) {
            if (hasSeenDoubleCRLF) {
                if (resultBuilder.length() > 0) {
                    resultBuilder.append("\n");
                }
                resultBuilder.append(line);
            }
            if (!line.equals("")) continue;
            hasSeenDoubleCRLF = true;
        }
        return this.parseResponse(resultBuilder.toString());
    }

    private ChromeResponse parseResponse(String rawJsonString) {
        if (rawJsonString.length() == 0) {
            return new ChromeResponse(0, null);
        }
        try {
            JSONObject jsonObject = new JSONObject(rawJsonString);
            if (!jsonObject.has("statusCode")) {
                throw new WebDriverException("Response had no status code.  Response was: " + rawJsonString);
            }
            if (jsonObject.getInt("statusCode") == 0) {
                if (!jsonObject.has("value") || jsonObject.isNull("value")) {
                    return new ChromeResponse(0, null);
                }
                Object value = jsonObject.get("value");
                Object parsedValue = this.parseJsonToObject(value);
                if (parsedValue instanceof ChromeWebElement) {
                    return new ChromeResponse(-1, ((ChromeWebElement)parsedValue).getElementId());
                }
                return new ChromeResponse(0, parsedValue);
            }
            String message = "";
            if (jsonObject.has("value") && jsonObject.get("value") instanceof JSONObject && jsonObject.getJSONObject("value").has("message") && jsonObject.getJSONObject("value").get("message") instanceof String) {
                message = jsonObject.getJSONObject("value").getString("message");
            }
            switch (jsonObject.getInt("statusCode")) {
                case 2: {
                    throw new WebDriverException(message);
                }
                case 3: {
                    throw new NoSuchWindowException(message);
                }
                case 7: {
                    throw new NoSuchElementException(message);
                }
                case 8: {
                    throw new NoSuchFrameException(message);
                }
                case 9: {
                    throw new UnsupportedOperationException(message);
                }
                case 10: {
                    throw new StaleElementReferenceException(message);
                }
                case 11: {
                    throw new ElementNotVisibleException(message);
                }
                case 12: {
                    throw new UnsupportedOperationException(message);
                }
                case 17: {
                    throw new WebDriverException(message);
                }
                case 19: {
                    throw new XPathLookupException(message);
                }
                case 99: {
                    throw new WebDriverException("An error occured when sending a native event");
                }
                case 500: {
                    if (message.equals("")) {
                        message = "An error occured due to the internals of Chrome. This does not mean your test failed. Try running your test again in isolation.";
                    }
                    throw new FatalChromeException(message);
                }
            }
            throw new WebDriverException("An error occured in the page");
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Object parseJsonToObject(Object value) throws JSONException {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)value;
            ArrayList<Object> arr = new ArrayList<Object>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                arr.add(this.parseJsonToObject(jsonArray.get(i)));
            }
            return arr;
        }
        if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            if (!object.has("type")) {
                throw new WebDriverException("Returned a JSONObjet which had no type");
            }
            if ("NULL".equals(object.getString("type"))) {
                return null;
            }
            if ("VALUE".equals(object.getString("type"))) {
                Object innerValue = object.get("value");
                if (innerValue instanceof Integer) {
                    innerValue = new Long(((Integer)innerValue).intValue());
                }
                return innerValue;
            }
            if ("ELEMENT".equals(object.getString("type"))) {
                return new ChromeWebElement(null, (String)object.get("value"));
            }
            if ("POINT".equals(object.getString("type"))) {
                if (!(object.has("x") && object.has("y") && object.get("x") instanceof Number && object.get("y") instanceof Number)) {
                    throw new WebDriverException("Couldn't construct Point without x and y coordinates");
                }
                return new Point(object.getInt("x"), object.getInt("y"));
            }
            if ("DIMENSION".equals(object.getString("type"))) {
                if (!(object.has("width") && object.has("height") && object.get("width") instanceof Number && object.get("height") instanceof Number)) {
                    throw new WebDriverException("Couldn't construct Dimension without width and height");
                }
                return new Dimension(object.getInt("width"), object.getInt("height"));
            }
            if ("COOKIE".equals(object.getString("type"))) {
                if (!object.has("name") || !object.has("value")) {
                    throw new WebDriverException("Couldn't construct Cookie without name and value");
                }
                return new Cookie(object.getString("name"), object.getString("value"));
            }
        } else {
            throw new WebDriverException("Didn't know how to deal with response value of type: " + value.getClass());
        }
        return null;
    }

    public void stopListening() {
        this.listen = false;
        this.listeningThread.stopListening();
        while (!this.serverSocket.isClosed()) {
            Thread.yield();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Object wrapArgumentForScriptExecution(Object argument) {
        JSONObject wrappedArgument;
        block8: {
            wrappedArgument = new JSONObject();
            try {
                if (argument instanceof String) {
                    wrappedArgument.put("type", (Object)"STRING");
                    wrappedArgument.put("value", argument);
                    break block8;
                }
                if (argument instanceof Boolean) {
                    wrappedArgument.put("type", (Object)"BOOLEAN");
                    wrappedArgument.put("value", argument);
                    break block8;
                }
                if (argument instanceof Number) {
                    wrappedArgument.put("type", (Object)"NUMBER");
                    wrappedArgument.put("value", argument);
                    break block8;
                }
                if (argument instanceof ChromeWebElement) {
                    wrappedArgument.put("type", (Object)"ELEMENT");
                    wrappedArgument.put("value", (Object)((ChromeWebElement)argument).getElementId());
                    break block8;
                }
                if (argument instanceof Collection) {
                    JSONArray array = new JSONArray();
                    for (Object o : (Collection)argument) {
                        array.put(this.wrapArgumentForScriptExecution(o));
                    }
                    return array;
                }
                throw new IllegalArgumentException("Could not wrap up javascript parameter " + argument + "(class: " + argument.getClass() + ")");
            }
            catch (JSONException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return wrappedArgument;
    }

    private class ListeningThread
    extends Thread {
        private boolean isListening = false;
        private Queue<Socket> sockets = new ConcurrentLinkedQueue<Socket>();
        private ServerSocket serverSocket;

        public ListeningThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void run() {
            if (!this.isListening) {
                this.listen();
            }
        }

        public void listen() {
            this.isListening = true;
            try {
                while (ChromeCommandExecutor.this.listen) {
                    this.sockets.add(this.serverSocket.accept());
                    ChromeCommandExecutor.this.hasClient = true;
                    ChromeCommandExecutor.this.hadClient = true;
                }
            }
            catch (SocketException e) {
                if (ChromeCommandExecutor.this.listen) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            catch (IOException e) {
                this.isListening = false;
                throw new WebDriverException((Throwable)e);
            }
        }

        public void stopListening() {
            try {
                this.closeCurrentSockets();
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
            finally {
                try {
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                    }
                }
                catch (Exception e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void closeCurrentSockets() {
            for (Socket socket : ChromeCommandExecutor.this.listeningThread.sockets) {
                try {
                    socket.close();
                    ChromeCommandExecutor.this.listeningThread.sockets.remove(socket);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

