/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.net.EphemeralPortRangeDetector;
import org.openqa.selenium.net.FixedIANAPortRange;
import org.openqa.selenium.net.LinuxEphemeralPortRangeDetector;
import org.openqa.selenium.net.OlderWindowsVersionEphemeralPortDetector;

public class PortProber {
    public static final int HIGHEST_PORT = 65535;
    public static final int START_OF_USER_PORTS = 1024;
    private static final Random random = new Random();
    private static final EphemeralPortRangeDetector ephemeralRangeDetector;

    private PortProber() {
    }

    public static int findFreePort() {
        for (int i = 0; i < 5; ++i) {
            int seedPort = PortProber.createAcceptablePort();
            int suggestedPort = PortProber.checkPortIsFree(seedPort);
            if (suggestedPort == -1) continue;
            return suggestedPort;
        }
        throw new RuntimeException("Unable to find a free port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createAcceptablePort() {
        Random random = PortProber.random;
        synchronized (random) {
            int LAST_PORT;
            int FIRST_PORT;
            int freeBelow;
            int freeAbove;
            int ephemeralStart = Math.max(1024, ephemeralRangeDetector.getLowestEphemeralPort());
            int ephemeralEnd = Math.min(65535, ephemeralRangeDetector.getHighestEphemeralPort());
            if (ephemeralEnd - ephemeralStart < 5000) {
                FixedIANAPortRange ianaRange = new FixedIANAPortRange();
                ephemeralStart = ianaRange.getLowestEphemeralPort();
                ephemeralEnd = ianaRange.getHighestEphemeralPort();
            }
            if ((freeAbove = 65535 - ephemeralEnd) > (freeBelow = Math.max(0, ephemeralStart - 1024))) {
                FIRST_PORT = ephemeralEnd;
                LAST_PORT = 65535;
            } else {
                FIRST_PORT = 1024;
                LAST_PORT = ephemeralStart;
            }
            if (FIRST_PORT == LAST_PORT) {
                return FIRST_PORT;
            }
            if (FIRST_PORT > LAST_PORT) {
                throw new UnsupportedOperationException("Could not find ephemeral port to use");
            }
            int randomInt = PortProber.random.nextInt();
            int portWithoutOffset = Math.abs(randomInt % (LAST_PORT - FIRST_PORT + 1));
            return portWithoutOffset + FIRST_PORT;
        }
    }

    private static boolean isFree(String bindHost, int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket();
        try {
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress(bindHost, port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    static int checkPortIsFree(int port) {
        if (PortProber.isFree("localhost", port) && PortProber.isFree("0.0.0.0", port) && PortProber.isFree("::1", port)) {
            return port;
        }
        return -1;
    }

    public static void waitForPortUp(int port, int timeout, TimeUnit unit) {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < end) {
            try (Socket socket2 = new Socket();){
                socket2.connect(new InetSocketAddress("localhost", port), 1000);
                return;
            }
            catch (ConnectException | SocketTimeoutException socket2) {
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static {
        Platform current = Platform.getCurrent();
        ephemeralRangeDetector = current.is(Platform.LINUX) ? LinuxEphemeralPortRangeDetector.getInstance() : (current.is(Platform.XP) ? new OlderWindowsVersionEphemeralPortDetector() : new FixedIANAPortRange());
    }
}

