/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Require {
    private static final String MUST_BE_SET = "%s must be set";
    private static final String MUST_NOT_BE_SET = "%s must not be set";
    private static final String MUST_EXIST = "%s must exist: %s";
    private static final String MUST_BE_DIR = "%s must be a directory: %s";
    private static final String MUST_BE_FILE = "%s must be a regular file: %s";
    private static final String MUST_BE_EQUAL = "%s must be equal to `%s`";
    private static final String MUST_BE_EXECUTABLE = "%s must be executable: %s";
    private static final String MUST_BE_NON_NEGATIVE = "%s must be 0 or greater";
    private static final String MUST_BE_POSITIVE = "%s must be greater than 0";
    private static final String MUST_BE_BETWEEN = "%s must be between %s and %s (inclusive)";
    private static final String MUST_NOT_BE_EMPTY = "%s must not be empty";

    private Require() {
    }

    public static void precondition(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static <T> T nonNull(String argName, @Nullable T arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format(MUST_BE_SET, argName));
        }
        return arg;
    }

    public static <T> T nonNull(String argName, @Nullable T arg, String message, Object ... args) {
        if (arg == null) {
            throw new IllegalArgumentException(String.join((CharSequence)" ", argName, String.format(message, args)));
        }
        return arg;
    }

    public static <T> void isNull(String argName, @Nullable T arg) {
        if (arg != null) {
            throw new IllegalArgumentException(String.format(MUST_NOT_BE_SET, argName));
        }
    }

    public static <T> ArgumentChecker<T> argument(String argName, @Nullable T arg) {
        return new ArgumentChecker<T>(argName, arg);
    }

    public static Duration nonNegative(String argName, @Nullable Duration arg) {
        Require.nonNull(argName, arg);
        if (arg.isNegative()) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, argName));
        }
        return arg;
    }

    public static Duration nonNegative(@Nullable Duration arg) {
        Require.nonNull("Duration", arg);
        if (arg.isNegative()) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, "Duration"));
        }
        return arg;
    }

    public static Duration positive(String argName, @Nullable Duration arg) {
        Require.nonNull(argName, arg);
        if (arg.isNegative() || arg.isZero()) {
            throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, argName));
        }
        return arg;
    }

    public static Duration positive(@Nullable Duration arg) {
        Require.nonNull("Duration", arg);
        if (arg.isNegative() || arg.isZero()) {
            throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, "Duration"));
        }
        return arg;
    }

    public static int nonNegative(String argName, @Nullable Integer number) {
        Require.nonNull(argName, number);
        if (number < 0) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, argName));
        }
        return number;
    }

    public static long nonNegative(String argName, @Nullable Long number) {
        Require.nonNull(argName, number);
        if (number < 0L) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, argName));
        }
        return number;
    }

    public static double nonNegative(String argName, @Nullable Double number) {
        Require.nonNull(argName, number);
        if (number < 0.0) {
            throw new IllegalArgumentException(String.format(MUST_BE_NON_NEGATIVE, argName));
        }
        return number;
    }

    public static int positive(String argName, @Nullable Integer number, @Nullable String message) {
        Require.nonNull(argName, number);
        if (number <= 0) {
            throw new IllegalArgumentException(Objects.requireNonNullElseGet(message, () -> String.format(MUST_BE_POSITIVE, argName)));
        }
        return number;
    }

    public static double positive(String argName, @Nullable Double number, @Nullable String message) {
        Require.nonNull(argName, number);
        if (number <= 0.0) {
            throw new IllegalArgumentException(Objects.requireNonNullElseGet(message, () -> String.format(MUST_BE_POSITIVE, argName)));
        }
        return number;
    }

    public static double positive(String argName, @Nullable Double number) {
        return Require.positive(argName, number, null);
    }

    public static int positive(String argName, @Nullable Integer number) {
        return Require.positive(argName, number, null);
    }

    public static long positive(String argName, @Nullable Long number) {
        Require.nonNull(argName, number);
        if (number <= 0L) {
            throw new IllegalArgumentException(String.format(MUST_BE_POSITIVE, argName));
        }
        return number;
    }

    public static double inRangeInclusive(String argName, @Nullable Double value, double min, double max) {
        Require.nonNull(argName, value);
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format(MUST_BE_BETWEEN, argName, min, max));
        }
        return value;
    }

    public static IntChecker argument(String argName, @Nullable Integer number) {
        return new IntChecker(argName, number);
    }

    public static PathChecker argument(String argName, @Nullable Path path) {
        return new PathChecker(argName, path);
    }

    public static <T> Collection<T> nonEmpty(String argName, @Nullable Collection<T> arg) {
        Require.nonNull(argName, arg);
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(String.format(MUST_NOT_BE_EMPTY, argName));
        }
        return arg;
    }

    public static void stateCondition(boolean state, String message, Object ... args) {
        if (!state) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public static <T> StateChecker<T> state(String name, @Nullable T state) {
        return new StateChecker<T>(name, state);
    }

    public static PathStateChecker state(String name, @Nullable Path path) {
        return new PathStateChecker(name, path);
    }

    public static class ArgumentChecker<T> {
        private final String argName;
        private final @Nullable T arg;

        ArgumentChecker(String argName, @Nullable T arg) {
            this.argName = argName;
            this.arg = arg;
        }

        public T nonNull() {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            return this.arg;
        }

        public T nonNull(String message, Object ... args) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(message, args));
            }
            return this.arg;
        }

        public T equalTo(Object other) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (!Objects.equals(this.arg, other)) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_EQUAL, this.argName, other));
            }
            return this.arg;
        }

        public T instanceOf(Class<?> cls) {
            if (this.arg == null) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_SET, this.argName));
            }
            if (!cls.isInstance(this.arg)) {
                throw new IllegalArgumentException(this.argName + " must be an instance of " + String.valueOf(cls));
            }
            return this.arg;
        }
    }

    public static class IntChecker {
        private final String argName;
        private final @Nullable Integer number;

        IntChecker(String argName, @Nullable Integer number) {
            this.argName = argName;
            this.number = number;
        }

        public int greaterThan(int max, String message) {
            Require.nonNull(this.argName, this.number);
            if (this.number <= max) {
                throw new IllegalArgumentException(message);
            }
            return this.number;
        }
    }

    public static class PathChecker {
        private final String argName;
        private final @Nullable Path path;

        PathChecker(String argName, @Nullable Path path) {
            this.argName = argName;
            this.path = path;
        }

        public Path isFile() {
            Require.nonNull(this.argName, this.path);
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format(Require.MUST_EXIST, this.argName, this.path.toAbsolutePath()));
            }
            if (!Files.isRegularFile(this.path, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_FILE, this.argName, this.path.toAbsolutePath()));
            }
            return this.path;
        }

        public Path isDirectory() {
            Require.nonNull(this.argName, this.path);
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format(Require.MUST_EXIST, this.argName, this.path.toAbsolutePath()));
            }
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format(Require.MUST_BE_DIR, this.argName, this.path.toAbsolutePath()));
            }
            return this.path;
        }
    }

    public static class StateChecker<T> {
        private final String name;
        private final @Nullable T state;

        StateChecker(String name, @Nullable T state) {
            this.name = name;
            this.state = state;
        }

        public T nonNull() {
            if (this.state == null) {
                throw new IllegalStateException(this.name + " must not be null");
            }
            return this.state;
        }

        public T nonNull(String message, Object ... args) {
            if (this.state == null) {
                throw new IllegalStateException(String.join((CharSequence)" ", this.name, String.format(message, args)));
            }
            return this.state;
        }

        public T instanceOf(Class<?> cls) {
            if (this.state == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (!cls.isInstance(this.state)) {
                throw new IllegalStateException(this.name + " must be an instance of " + String.valueOf(cls));
            }
            return this.state;
        }
    }

    public static class PathStateChecker {
        private final String name;
        private final @Nullable Path path;

        PathStateChecker(String name, @Nullable Path path) {
            this.name = name;
            this.path = path;
        }

        public Path isFile() {
            if (this.path == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (Files.notExists(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.path));
            }
            if (!Files.isRegularFile(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_BE_FILE, this.name, this.path));
            }
            return this.path;
        }

        public Path isDirectory() {
            if (this.path == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (Files.notExists(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.path));
            }
            if (!Files.isDirectory(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_BE_DIR, this.name, this.path));
            }
            return this.path;
        }

        public Path isExecutable() {
            if (this.path == null) {
                throw new IllegalStateException(String.format(Require.MUST_BE_SET, this.name));
            }
            if (Files.notExists(this.path, new LinkOption[0])) {
                throw new IllegalStateException(String.format(Require.MUST_EXIST, this.name, this.path));
            }
            if (!Files.isExecutable(this.path)) {
                throw new IllegalStateException(String.format(Require.MUST_BE_EXECUTABLE, this.name, this.path));
            }
            return this.path;
        }
    }
}

