/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class Debug {
    private static final boolean IS_DEBUG;
    private static boolean loggerConfigured;
    private static Logger seleniumLogger;

    private Debug() {
    }

    public static boolean isDebugging() {
        return IS_DEBUG;
    }

    public static Level getDebugLogLevel() {
        return Debug.isDebugging() ? Level.INFO : Level.FINE;
    }

    public static boolean isDebugAll() {
        return Boolean.parseBoolean(System.getenv("SE_DEBUG"));
    }

    public static void configureLogger() {
        if (!Debug.isDebugAll() || loggerConfigured) {
            return;
        }
        seleniumLogger = Logger.getLogger("org.openqa.selenium");
        seleniumLogger.setLevel(Level.FINE);
        StreamHandler handler = new StreamHandler(System.err, new SimpleFormatter());
        handler.setLevel(Level.FINE);
        seleniumLogger.addHandler(handler);
        loggerConfigured = true;
    }

    static {
        loggerConfigured = false;
        IS_DEBUG = Boolean.getBoolean("selenium.debug") || Boolean.getBoolean("selenium.webdriver.verbose");
    }
}

