/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;

public class W3CCapabilityKeysValidator {
    private static final Logger LOG = Logger.getLogger(W3CCapabilityKeysValidator.class.getName());
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();

    public static void validateCapability(String capabilityName) {
        if (!ACCEPTED_W3C_PATTERNS.test(capabilityName)) {
            LOG.log(Level.WARNING, () -> String.format("Support for Legacy Capabilities is deprecated; You are sending \"%s\" which is an invalid capability. Please update to W3C Syntax: https://www.selenium.dev/blog/2022/legacy-protocol-support/", capabilityName));
        }
    }
}

