/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.LoggingPreferences;

class SharedCapabilitiesMethods {
    private SharedCapabilitiesMethods() {
    }

    static int hashCode(Capabilities caps) {
        return caps.getCapabilityNames().stream().sorted().mapToInt(name -> Objects.hash(name, caps.getCapability((String)name))).reduce(0, (l, r) -> l ^ r);
    }

    static boolean equals(Capabilities left, Capabilities right) {
        return left.hashCode() == right.hashCode();
    }

    static void setCapability(Map<String, Object> caps, String key, Object value) {
        if ("loggingPrefs".equals(key) && value instanceof Map) {
            LoggingPreferences prefs = new LoggingPreferences();
            Map prefsMap = (Map)value;
            prefsMap.forEach((pKey, pValue) -> prefs.enable((String)pKey, LogLevelMapping.toLevel(pValue)));
            caps.put(key, prefs);
            return;
        }
        if ("platform".equals(key) && value instanceof String) {
            try {
                caps.put(key, (Object)Platform.fromString((String)value));
            }
            catch (WebDriverException e) {
                caps.put(key, value);
            }
            return;
        }
        if ("unexpectedAlertBehaviour".equals(key)) {
            caps.put("unexpectedAlertBehaviour", value);
            caps.put("unhandledPromptBehavior", value);
            return;
        }
        caps.put(key, value);
    }

    static String toString(Capabilities caps) {
        IdentityHashMap<Object, String> seen = new IdentityHashMap<Object, String>();
        return "Capabilities " + SharedCapabilitiesMethods.abbreviate(seen, caps.asMap());
    }

    private static String abbreviate(Map<Object, String> seen, Object stringify) {
        if (stringify == null) {
            return "null";
        }
        StringBuilder value = new StringBuilder();
        if (stringify.getClass().isArray()) {
            value.append("[");
            value.append(Stream.of((Object[])stringify).map(item -> SharedCapabilitiesMethods.abbreviate(seen, item)).collect(Collectors.joining(", ")));
            value.append("]");
        } else if (stringify instanceof Collection) {
            value.append("[");
            value.append(((Collection)stringify).stream().map(item -> SharedCapabilitiesMethods.abbreviate(seen, item)).collect(Collectors.joining(", ")));
            value.append("]");
        } else if (stringify instanceof Map) {
            value.append("{");
            value.append(((Map)stringify).entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).map(entry -> String.format("%s: %s", entry.getKey(), SharedCapabilitiesMethods.abbreviate(seen, entry.getValue()))).collect(Collectors.joining(", ")));
            value.append("}");
        } else {
            String s = String.valueOf(stringify);
            if (s.length() > 30) {
                value.append(s, 0, 27).append("...");
            } else {
                value.append(s);
            }
        }
        seen.put(stringify, value.toString());
        return value.toString();
    }
}

