/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class By {
    public static By id(String id) {
        return new ById(id);
    }

    public static By linkText(String linkText) {
        return new ByLinkText(linkText);
    }

    public static By partialLinkText(String partialLinkText) {
        return new ByPartialLinkText(partialLinkText);
    }

    public static By name(String name) {
        return new ByName(name);
    }

    public static By tagName(String tagName) {
        return new ByTagName(tagName);
    }

    public static By xpath(String xpathExpression) {
        return new ByXPath(xpathExpression);
    }

    public static By className(String className) {
        return new ByClassName(className);
    }

    public static By cssSelector(String cssSelector) {
        return new ByCssSelector(cssSelector);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> allElements = this.findElements(context);
        if (allElements == null || allElements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element using " + this.toString());
        }
        return allElements.get(0);
    }

    public abstract List<WebElement> findElements(SearchContext var1);

    public boolean equals(Object o) {
        if (!(o instanceof By)) {
            return false;
        }
        By that = (By)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[unknown locator]";
    }

    public static class ByCssSelector
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = -3910258723099459239L;
        private final String cssSelector;

        public ByCssSelector(String cssSelector) {
            if (cssSelector == null) {
                throw new IllegalArgumentException("Cannot find elements when the selector is null");
            }
            this.cssSelector = cssSelector;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("css selector", this.cssSelector);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("css selector", this.cssSelector);
        }

        @Override
        public String toString() {
            return "By.cssSelector: " + this.cssSelector;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "css selector");
            asJson.put("value", this.cssSelector);
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ByClassName
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = -8737882849130394673L;
        private final String className;

        public ByClassName(String className) {
            if (className == null) {
                throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
            }
            this.className = className;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("class name", this.className);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("class name", this.className);
        }

        private String containingWord(String attribute, String word) {
            return "contains(concat(' ',normalize-space(@" + attribute + "),' '),' " + word + " ')";
        }

        @Override
        public String toString() {
            return "By.className: " + this.className;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "css selector");
            asJson.put("value", Stream.of(this.className.split("\\s+")).map(str -> "." + str).collect(Collectors.joining(" ")));
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ByXPath
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = -6727228887685051584L;
        private final String xpathExpression;

        public ByXPath(String xpathExpression) {
            if (xpathExpression == null) {
                throw new IllegalArgumentException("Cannot find elements when the XPath is null.");
            }
            this.xpathExpression = xpathExpression;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("xpath", this.xpathExpression);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("xpath", this.xpathExpression);
        }

        @Override
        public String toString() {
            return "By.xpath: " + this.xpathExpression;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "xpath");
            asJson.put("value", this.xpathExpression);
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ByTagName
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = 4699295846984948351L;
        private final String tagName;

        public ByTagName(String tagName) {
            if (tagName == null) {
                throw new IllegalArgumentException("Cannot find elements when the tag name is null.");
            }
            this.tagName = tagName;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("tag name", this.tagName);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("tag name", this.tagName);
        }

        @Override
        public String toString() {
            return "By.tagName: " + this.tagName;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "tag name");
            asJson.put("value", this.tagName);
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ByName
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = 376317282960469555L;
        private final String name;

        public ByName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Cannot find elements when name text is null.");
            }
            this.name = name;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("name", this.name);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("name", this.name);
        }

        @Override
        public String toString() {
            return "By.name: " + this.name;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "css selector");
            asJson.put("value", String.format("*[name='%s']", this.name.replace("'", "\\'")));
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ByPartialLinkText
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = 1163955344140679054L;
        private final String partialLinkText;

        public ByPartialLinkText(String partialLinkText) {
            if (partialLinkText == null) {
                throw new IllegalArgumentException("Cannot find elements when the link text is null.");
            }
            this.partialLinkText = partialLinkText;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("partial link text", this.partialLinkText);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("partial link text", this.partialLinkText);
        }

        @Override
        public String toString() {
            return "By.partialLinkText: " + this.partialLinkText;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "partial link text");
            asJson.put("value", this.partialLinkText);
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ByLinkText
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = 1967414585359739708L;
        private final String linkText;

        public ByLinkText(String linkText) {
            if (linkText == null) {
                throw new IllegalArgumentException("Cannot find elements when the link text is null.");
            }
            this.linkText = linkText;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("link text", this.linkText);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("link text", this.linkText);
        }

        @Override
        public String toString() {
            return "By.linkText: " + this.linkText;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "link text");
            asJson.put("value", this.linkText);
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static class ById
    extends StandardLocator
    implements Serializable {
        private static final long serialVersionUID = 5341968046120372169L;
        private final String id;

        public ById(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Cannot find elements when the id is null.");
            }
            this.id = id;
        }

        @Override
        public <T extends SearchContext> WebElement findElement(T driver, BiFunction<String, String, WebElement> finder) {
            return finder.apply("id", this.id);
        }

        @Override
        public <T extends SearchContext> List<WebElement> findElements(T driver, BiFunction<String, String, List<WebElement>> finder) {
            return finder.apply("id", this.id);
        }

        @Override
        public String toString() {
            return "By.id: " + this.id;
        }

        private Map<String, Object> toJson() {
            HashMap<String, String> asJson = new HashMap<String, String>();
            asJson.put("using", "css selector");
            asJson.put("value", Stream.of(this.id.split("\\s+")).map(str -> "#" + str).collect(Collectors.joining(" ")));
            return Collections.unmodifiableMap(asJson);
        }
    }

    public static abstract class StandardLocator
    extends By {
        @Override
        public WebElement findElement(SearchContext context) {
            return context.findElement(this);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return context.findElements(this);
        }

        public abstract <T extends SearchContext> WebElement findElement(T var1, BiFunction<String, String, WebElement> var2);

        public abstract <T extends SearchContext> List<WebElement> findElements(T var1, BiFunction<String, String, List<WebElement>> var2);
    }
}

