/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Arrays;

public enum Keys implements CharSequence
{
    NULL('\ue000'),
    CANCEL('\ue001'),
    HELP('\ue002'),
    BACK_SPACE('\ue003'),
    TAB('\ue004'),
    CLEAR('\ue005'),
    RETURN('\ue006'),
    ENTER('\ue007'),
    SHIFT('\ue008'),
    LEFT_SHIFT(SHIFT),
    CONTROL('\ue009'),
    LEFT_CONTROL(CONTROL),
    ALT('\ue00a'),
    LEFT_ALT(ALT),
    PAUSE('\ue00b'),
    ESCAPE('\ue00c'),
    SPACE('\ue00d'),
    PAGE_UP('\ue00e'),
    PAGE_DOWN('\ue00f'),
    END('\ue010'),
    HOME('\ue011'),
    LEFT('\ue012'),
    ARROW_LEFT(LEFT),
    UP('\ue013'),
    ARROW_UP(UP),
    RIGHT('\ue014'),
    ARROW_RIGHT(RIGHT),
    DOWN('\ue015'),
    ARROW_DOWN(DOWN),
    INSERT('\ue016'),
    DELETE('\ue017'),
    SEMICOLON('\ue018'),
    EQUALS('\ue019'),
    NUMPAD0('\ue01a'),
    NUMPAD1('\ue01b'),
    NUMPAD2('\ue01c'),
    NUMPAD3('\ue01d'),
    NUMPAD4('\ue01e'),
    NUMPAD5('\ue01f'),
    NUMPAD6('\ue020'),
    NUMPAD7('\ue021'),
    NUMPAD8('\ue022'),
    NUMPAD9('\ue023'),
    MULTIPLY('\ue024'),
    ADD('\ue025'),
    SEPARATOR('\ue026'),
    SUBTRACT('\ue027'),
    DECIMAL('\ue028'),
    DIVIDE('\ue029'),
    F1('\ue031'),
    F2('\ue032'),
    F3('\ue033'),
    F4('\ue034'),
    F5('\ue035'),
    F6('\ue036'),
    F7('\ue037'),
    F8('\ue038'),
    F9('\ue039'),
    F10('\ue03a'),
    F11('\ue03b'),
    F12('\ue03c'),
    META('\ue03d'),
    COMMAND(META),
    ZENKAKU_HANKAKU('\ue040');

    private final char keyCode;
    private final int codePoint;

    private Keys(Keys key) {
        this(key.charAt(0));
    }

    private Keys(char keyCode) {
        this.keyCode = keyCode;
        this.codePoint = String.valueOf(keyCode).codePoints().findFirst().getAsInt();
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    @Override
    public char charAt(int index) {
        if (index == 0) {
            return this.keyCode;
        }
        return '\u0000';
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == 1) {
            return String.valueOf(this.keyCode);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String toString() {
        return String.valueOf(this.keyCode);
    }

    public static String chord(CharSequence ... value) {
        return Keys.chord(Arrays.asList(value));
    }

    public static String chord(Iterable<CharSequence> value) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : value) {
            builder.append(seq);
        }
        builder.append(NULL);
        return builder.toString();
    }

    public static Keys getKeyFromUnicode(char key) {
        for (Keys unicodeKey : Keys.values()) {
            if (unicodeKey.charAt(0) != key) continue;
            return unicodeKey;
        }
        return null;
    }
}

