/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.servlets;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.seleniumhq.jetty9.http.HttpField;
import org.seleniumhq.jetty9.http.HttpFields;
import org.seleniumhq.jetty9.http.HttpHeader;
import org.seleniumhq.jetty9.http.HttpMethod;
import org.seleniumhq.jetty9.http.HttpURI;
import org.seleniumhq.jetty9.http.HttpVersion;
import org.seleniumhq.jetty9.server.PushBuilder;
import org.seleniumhq.jetty9.server.Request;
import org.seleniumhq.jetty9.util.StringUtil;
import org.seleniumhq.jetty9.util.annotation.ManagedAttribute;
import org.seleniumhq.jetty9.util.annotation.ManagedObject;
import org.seleniumhq.jetty9.util.annotation.ManagedOperation;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;

@ManagedObject(value="Push cache based on the HTTP 'Referer' header")
public class PushCacheFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(PushCacheFilter.class);
    private final Set<Integer> _ports = new HashSet<Integer>();
    private final Set<String> _hosts = new HashSet<String>();
    private final ConcurrentMap<String, PrimaryResource> _cache = new ConcurrentHashMap<String, PrimaryResource>();
    private long _associatePeriod = 4000L;
    private int _maxAssociations = 16;
    private long _renew = System.nanoTime();

    @Override
    public void init(FilterConfig config) throws ServletException {
        String ports;
        String hosts;
        String maxAssociations;
        String associatePeriod = config.getInitParameter("associatePeriod");
        if (associatePeriod != null) {
            this._associatePeriod = Long.parseLong(associatePeriod);
        }
        if ((maxAssociations = config.getInitParameter("maxAssociations")) != null) {
            this._maxAssociations = Integer.parseInt(maxAssociations);
        }
        if ((hosts = config.getInitParameter("hosts")) != null) {
            Collections.addAll(this._hosts, StringUtil.csvSplit(hosts));
        }
        if ((ports = config.getInitParameter("ports")) != null) {
            for (String p : StringUtil.csvSplit(ports)) {
                this._ports.add(Integer.parseInt(p));
            }
        }
        config.getServletContext().setAttribute(config.getFilterName(), this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("period={} max={} hosts={} ports={}", this._associatePeriod, this._maxAssociations, this._hosts, this._ports);
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        PrimaryResource primaryResource;
        HttpServletRequest request = (HttpServletRequest)req;
        Request jettyRequest = Request.getBaseRequest(request);
        if (HttpVersion.fromString(request.getProtocol()).getVersion() < 20 || !HttpMethod.GET.is(request.getMethod()) || !jettyRequest.isPushSupported()) {
            chain.doFilter(req, resp);
            return;
        }
        long now = System.nanoTime();
        HttpFields fields = jettyRequest.getHttpFields();
        boolean conditional = false;
        String referrer = null;
        block4: for (int i = 0; i < fields.size(); ++i) {
            HttpField field = fields.getField(i);
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case IF_MATCH: 
                case IF_MODIFIED_SINCE: 
                case IF_NONE_MATCH: 
                case IF_UNMODIFIED_SINCE: {
                    conditional = true;
                    break block4;
                }
                case REFERER: {
                    referrer = field.getValue();
                }
                default: {
                    continue block4;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} referrer={} conditional={}", request.getMethod(), request.getRequestURI(), referrer, conditional);
        }
        String path = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null) {
            path = path + "?" + query;
        }
        if (referrer != null) {
            boolean referredFromHere;
            HttpURI referrerURI = new HttpURI(referrer);
            String host = referrerURI.getHost();
            int port = referrerURI.getPort();
            if (port <= 0) {
                port = request.isSecure() ? 443 : 80;
            }
            boolean bl = referredFromHere = this._hosts.size() > 0 ? this._hosts.contains(host) : host.equals(request.getServerName());
            if (referredFromHere &= this._ports.size() > 0 ? this._ports.contains(port) : port == request.getServerPort()) {
                if (HttpMethod.GET.is(request.getMethod())) {
                    String referrerPath = referrerURI.getPath();
                    if (referrerPath == null) {
                        referrerPath = "/";
                    }
                    if (referrerPath.startsWith(request.getContextPath() + "/")) {
                        if (!referrerPath.equals(path)) {
                            long primaryTimestamp;
                            PrimaryResource primaryResource2 = (PrimaryResource)this._cache.get(referrerPath);
                            if (primaryResource2 != null && (primaryTimestamp = primaryResource2._timestamp.get()) != 0L) {
                                if (now - primaryTimestamp < TimeUnit.MILLISECONDS.toNanos(this._associatePeriod)) {
                                    Set associated = primaryResource2._associated;
                                    if (associated.size() <= this._maxAssociations) {
                                        if (associated.add(path) && LOG.isDebugEnabled()) {
                                            LOG.debug("Associated {} to {}", path, referrerPath);
                                        }
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("Not associated {} to {}, exceeded max associations of {}", path, referrerPath, this._maxAssociations);
                                    }
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug("Not associated {} to {}, outside associate period of {}ms", path, referrerPath, this._associatePeriod);
                                }
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Not associated {} to {}, referring to self", path, referrerPath);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Not associated {} to {}, different context", path, referrerPath);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("External referrer {}", referrer);
            }
        }
        if ((primaryResource = (PrimaryResource)this._cache.get(path)) == null) {
            PrimaryResource r = new PrimaryResource();
            primaryResource = this._cache.putIfAbsent(path, r);
            primaryResource = primaryResource == null ? r : primaryResource;
            primaryResource._timestamp.compareAndSet(0L, now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cached primary resource {}", path);
            }
        } else {
            long last = primaryResource._timestamp.get();
            if (last < this._renew && primaryResource._timestamp.compareAndSet(last, now)) {
                primaryResource._associated.clear();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clear associated resources for {}", path);
                }
            }
        }
        if (!conditional && !primaryResource._associated.isEmpty()) {
            PushBuilder pushBuilder = jettyRequest.getPushBuilder();
            ArrayDeque<PrimaryResource> queue = new ArrayDeque<PrimaryResource>();
            queue.offer(primaryResource);
            while (!queue.isEmpty()) {
                PrimaryResource parent = (PrimaryResource)queue.poll();
                for (String childPath : parent._associated) {
                    PrimaryResource child = (PrimaryResource)this._cache.get(childPath);
                    if (child != null) {
                        queue.offer(child);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Pushing {} for {}", childPath, path);
                    }
                    pushBuilder.path(childPath).push();
                }
            }
        }
        chain.doFilter(request, resp);
    }

    @Override
    public void destroy() {
        this.clearPushCache();
    }

    @ManagedAttribute(value="The push cache contents")
    public Map<String, String> getPushCache() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : this._cache.entrySet()) {
            PrimaryResource resource = (PrimaryResource)entry.getValue();
            String value = String.format("size=%d: %s", resource._associated.size(), new TreeSet(resource._associated));
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    @ManagedOperation(value="Renews the push cache contents", impact="ACTION")
    public void renewPushCache() {
        this._renew = System.nanoTime();
    }

    @ManagedOperation(value="Clears the push cache contents", impact="ACTION")
    public void clearPushCache() {
        this._cache.clear();
    }

    private static class PrimaryResource {
        private final Set<String> _associated = Collections.newSetFromMap(new ConcurrentHashMap());
        private final AtomicLong _timestamp = new AtomicLong();

        private PrimaryResource() {
        }
    }
}

