/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.time.Duration;
import org.htmlunit.WebClient;
import org.openqa.selenium.WebDriver;

public class HtmlUnitTimeouts
implements WebDriver.Timeouts {
    private long implicitWait_ = 0L;
    private long scriptTimeout_ = 30000L;
    private long pageLoadTimeout_ = 300000L;
    private WebClient webClient_ = null;

    public HtmlUnitTimeouts() {
    }

    public HtmlUnitTimeouts(WebClient webClient) {
        this.webClient_ = webClient;
    }

    public Duration getImplicitWaitTimeout() {
        return Duration.ofMillis(this.implicitWait_);
    }

    public WebDriver.Timeouts implicitlyWait(Duration duration) {
        this.implicitWait_ = Math.max(0L, duration.toMillis());
        return this;
    }

    public WebDriver.Timeouts scriptTimeout(Duration duration) {
        this.scriptTimeout_ = duration.toMillis();
        return this;
    }

    public Duration getScriptTimeout() {
        return Duration.ofMillis(this.scriptTimeout_);
    }

    public WebDriver.Timeouts pageLoadTimeout(Duration duration) {
        this.pageLoadTimeout_ = duration.toMillis();
        HtmlUnitTimeouts.setPageLoadTimeoutForWebClient(this.webClient_, this.pageLoadTimeout_);
        return this;
    }

    public Duration getPageLoadTimeout() {
        return Duration.ofMillis(this.pageLoadTimeout_);
    }

    private static void setPageLoadTimeoutForWebClient(WebClient webClient, long timeout) {
        if (webClient != null) {
            webClient.getOptions().setTimeout(Math.max((int)timeout, 0));
        }
    }
}

