/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.util.Map;
import java.util.Optional;
import org.htmlunit.BrowserVersion;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.Browser;

public final class BrowserVersionDeterminer {
    public static BrowserVersion determine(Capabilities capabilities) {
        BrowserVersion browserVersionObject;
        block16: {
            String browserVersion;
            String browserName;
            String[] splitVersion;
            if (!Browser.HTMLUNIT.is(capabilities)) {
                throw new IllegalArgumentException("When building an HtmlUntDriver, the capability browser name must be set to '" + Browser.HTMLUNIT.browserName() + "' but was '" + capabilities.getBrowserName() + "'.");
            }
            String rawVersion = BrowserVersionDeterminer.getBrowserVersion(capabilities);
            String[] stringArray = splitVersion = rawVersion == null ? new String[]{} : rawVersion.split("-");
            if (splitVersion.length > 1) {
                browserName = splitVersion[0];
                browserVersion = splitVersion[1];
            } else {
                browserName = BrowserVersionDeterminer.getBrowserVersion(capabilities);
                browserVersion = null;
            }
            if (browserName.equalsIgnoreCase(BrowserVersion.CHROME.getNickname()) || "googlechrome".equalsIgnoreCase(browserName)) {
                browserVersionObject = BrowserVersion.CHROME;
            } else if (browserName.equalsIgnoreCase(BrowserVersion.EDGE.getNickname()) || "MicrosoftEdge".equalsIgnoreCase(browserName)) {
                browserVersionObject = BrowserVersion.EDGE;
            } else if (browserName.equalsIgnoreCase(BrowserVersion.FIREFOX.getNickname()) || "firefox".equalsIgnoreCase(browserName)) {
                if ("esr".equalsIgnoreCase(browserVersion)) {
                    browserVersionObject = BrowserVersion.FIREFOX_ESR;
                } else {
                    try {
                        int version = Integer.parseInt(browserVersion);
                        if (version == 78 || version == 91 || version == 102 || version == 115) {
                            browserVersionObject = BrowserVersion.FIREFOX_ESR;
                            break block16;
                        }
                        if (version == BrowserVersion.FIREFOX.getBrowserVersionNumeric()) {
                            browserVersionObject = BrowserVersion.FIREFOX;
                            break block16;
                        }
                        browserVersionObject = BrowserVersion.FIREFOX;
                    }
                    catch (NumberFormatException e) {
                        browserVersionObject = BrowserVersion.FIREFOX;
                    }
                }
            } else {
                browserVersionObject = BrowserVersion.getDefault();
            }
        }
        Object rawLanguage = capabilities.getCapability("browserLanguage");
        if (rawLanguage instanceof String) {
            return new BrowserVersion.BrowserVersionBuilder(browserVersionObject).setBrowserLanguage((String)rawLanguage).build();
        }
        return browserVersionObject;
    }

    public static String getBrowserVersion(Capabilities capabilities) {
        Map capsMap = capabilities.asMap();
        return String.valueOf(Optional.ofNullable(capsMap.get("garg:browserVersion")).or(() -> Optional.ofNullable(capsMap.get("browserVersion"))).orElse(""));
    }

    private BrowserVersionDeterminer() {
    }
}

