/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlNumberInput;
import com.gargoylesoftware.htmlunit.html.Keyboard;
import java.io.IOException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboardMapping;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.InputKeysContainer;
import org.openqa.selenium.htmlunit.KeyboardModifiersState;

public class HtmlUnitKeyboard {
    private final KeyboardModifiersState modifiersState_ = new KeyboardModifiersState();
    private final HtmlUnitDriver parent_;
    private HtmlElement lastElement_;

    HtmlUnitKeyboard(HtmlUnitDriver parent) {
        this.parent_ = parent;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        HtmlUnitWebElement htmlElem = (HtmlUnitWebElement)this.parent_.switchTo().activeElement();
        this.sendKeys(htmlElem, false, keysToSend);
    }

    void sendKeys(HtmlUnitWebElement htmlElem, boolean releaseAllAtEnd, CharSequence ... value) {
        htmlElem.verifyCanInteractWithElement(false);
        HtmlElement element = (HtmlElement)htmlElem.getElement();
        boolean inputElementInsideForm = element instanceof HtmlInput && element.getEnclosingForm() != null;
        InputKeysContainer keysContainer = new InputKeysContainer(inputElementInsideForm, value);
        htmlElem.switchFocusToThisIfNeeded();
        this.sendKeys(element, keysContainer, releaseAllAtEnd);
        if (inputElementInsideForm && keysContainer.wasSubmitKeyFound()) {
            htmlElem.submitImpl();
        }
    }

    private void sendKeys(HtmlElement element, InputKeysContainer keysToSend, boolean releaseAllAtEnd) {
        keysToSend.setCapitalization(this.modifiersState_.isShiftPressed());
        String keysSequence = keysToSend.toString();
        if (element instanceof HtmlFileInput) {
            HtmlFileInput fileInput = (HtmlFileInput)element;
            fileInput.setValue(keysSequence);
            return;
        }
        try {
            boolean startAtEnd = this.lastElement_ != element && !(element instanceof HtmlNumberInput);
            Keyboard keyboard = this.asHtmlUnitKeyboard(startAtEnd, keysSequence, true);
            if (releaseAllAtEnd) {
                if (this.isShiftPressed()) {
                    this.addToKeyboard(keyboard, Keys.SHIFT.charAt(0), false);
                }
                if (this.isAltPressed()) {
                    this.addToKeyboard(keyboard, Keys.ALT.charAt(0), false);
                }
                if (this.isCtrlPressed()) {
                    this.addToKeyboard(keyboard, Keys.CONTROL.charAt(0), false);
                }
            }
            element.type(keyboard);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.lastElement_ = element;
    }

    private Keyboard asHtmlUnitKeyboard(boolean startAtEnd, CharSequence keysSequence, boolean isPress) {
        Keyboard keyboard = new Keyboard(startAtEnd);
        for (int i = 0; i < keysSequence.length(); ++i) {
            char ch = keysSequence.charAt(i);
            this.addToKeyboard(keyboard, ch, isPress);
        }
        return keyboard;
    }

    private void addToKeyboard(Keyboard keyboard, char ch, boolean isPress) {
        if (HtmlUnitKeyboardMapping.isSpecialKey(ch)) {
            int keyCode = HtmlUnitKeyboardMapping.getKeysMapping(ch);
            if (isPress) {
                keyboard.press(keyCode);
                this.modifiersState_.storeKeyDown(ch);
            } else {
                keyboard.release(keyCode);
                this.modifiersState_.storeKeyUp(ch);
            }
        } else {
            keyboard.type(ch);
        }
    }

    public void pressKey(CharSequence keyToPress) {
        HtmlUnitWebElement htmlElement = (HtmlUnitWebElement)this.parent_.switchTo().activeElement();
        HtmlElement element = (HtmlElement)htmlElement.getElement();
        try {
            element.type(this.asHtmlUnitKeyboard(this.lastElement_ != element, keyToPress, true));
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        for (int i = 0; i < keyToPress.length(); ++i) {
            char ch = keyToPress.charAt(i);
            this.modifiersState_.storeKeyDown(ch);
        }
    }

    public void releaseKey(CharSequence keyToRelease) {
        HtmlUnitWebElement htmlElement = (HtmlUnitWebElement)this.parent_.switchTo().activeElement();
        HtmlElement element = (HtmlElement)htmlElement.getElement();
        try {
            element.type(this.asHtmlUnitKeyboard(this.lastElement_ != element, keyToRelease, false));
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        for (int i = 0; i < keyToRelease.length(); ++i) {
            char ch = keyToRelease.charAt(i);
            this.modifiersState_.storeKeyUp(ch);
        }
    }

    public boolean isShiftPressed() {
        return this.modifiersState_.isShiftPressed();
    }

    public boolean isCtrlPressed() {
        return this.modifiersState_.isCtrlPressed();
    }

    public boolean isAltPressed() {
        return this.modifiersState_.isAltPressed();
    }

    public boolean isPressed(char ch) {
        return this.modifiersState_.isPressed(ch);
    }

    public boolean isPressed(Keys keys) {
        return this.modifiersState_.isPressed(keys);
    }
}

