/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent.monitors;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.Monitor;

public class HighlightOnError
extends Monitor.NULL {
    protected final WebDriver driver;

    public HighlightOnError(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public FluentExecutionStopped exceptionDuringExecution(FluentExecutionStopped ex, WebElement webElement) {
        if (webElement != null) {
            try {
                this.executeScript(webElement);
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
        return ex;
    }

    protected void executeScript(WebElement webElement) {
        ((JavascriptExecutor)this.driver).executeScript(this.highlightOperation(), new Object[]{webElement, this.highlightValue()});
    }

    protected String highlightValue() {
        return "border: 2px dashed red;";
    }

    protected String highlightOperation() {
        return "arguments[0].setAttribute('style', arguments[1]);";
    }

    public static class ForDisabledElements
    extends HighlightOnError {
        public ForDisabledElements(WebDriver delegate) {
            super(delegate);
        }

        @Override
        public void executeScript(WebElement webElement) {
            boolean elementWasDisplayed = webElement.isDisplayed();
            super.executeScript(webElement);
            if (!elementWasDisplayed) {
                ((JavascriptExecutor)this.driver).executeScript("arguments[0].innerHTML=arguments[1]+arguments[0].innerHTML", new Object[]{webElement, "<span style=\"color: darkred; background: lightpink;\" >This element was not being displayed</span>"});
            }
        }
    }
}

