/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.selenium.fluent.monitors;

import org.openqa.selenium.WebElement;
import org.seleniumhq.selenium.fluent.FluentExecutionStopped;
import org.seleniumhq.selenium.fluent.Monitor;

public class CompositeMonitor
implements Monitor {
    private Monitor[] monitors;

    public CompositeMonitor(Monitor ... monitors) {
        this.monitors = monitors;
        assert (monitors.length != 0);
    }

    @Override
    public Monitor.Timer start(String item) {
        for (Monitor monitor : this.monitors) {
            Monitor.Timer foo = monitor.start(item);
            if (foo instanceof Monitor.Timer.NULL) continue;
            return foo;
        }
        return this.monitors[0].start(item);
    }

    @Override
    public FluentExecutionStopped exceptionDuringExecution(FluentExecutionStopped ex, WebElement webElement) {
        FluentExecutionStopped rv = ex;
        for (Monitor monitor : this.monitors) {
            rv = monitor.exceptionDuringExecution(rv, webElement);
        }
        return rv;
    }
}

