/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.spring.batch.internal;

import com.google.common.base.Strings;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.seedstack.seed.cli.CliCommand;
import org.seedstack.seed.cli.CliOption;
import org.seedstack.seed.cli.CommandLineHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.launch.JobLauncher;

@CliCommand(value="run-job", description="Launch Spring Batch jobs")
public class SpringBatchCommandLineHandler
implements CommandLineHandler {
    private static final String DEFAULT_JOB_LAUNCHER_NAME = "jobLauncher";
    private static final String DEFAULT_JOB_NAME = "job";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBatchCommandLineHandler.class);
    @CliOption(name="l", longName="jobLauncher", valueCount=1, description="Job launcher name to use")
    String optionJobLauncherName;
    @CliOption(name="j", longName="job", valueCount=1, description="Job name to launch")
    String optionJobName;
    @CliOption(name="P", longName="jobParameter", valueCount=-1, valueSeparator=61, description="A job parameter")
    Map<String, String> optionJobParameters;
    @Inject
    Injector injector;

    public Integer call() throws JobExecutionException {
        JobParameters jobParameters;
        Job job;
        Integer batchExitStatus = 0;
        JobLauncher jobLauncher = this.getJobLauncher();
        JobExecution jobExecution = jobLauncher.run(job = this.getJob(), jobParameters = this.getJobParameters());
        BatchStatus batchStatus = jobExecution.getStatus();
        if (!batchStatus.equals((Object)BatchStatus.COMPLETED)) {
            batchExitStatus = 1;
        }
        LOGGER.info("Exit with status : " + batchStatus);
        return batchExitStatus;
    }

    private JobParameters getJobParameters() {
        if (this.optionJobParameters != null && !this.optionJobParameters.isEmpty()) {
            HashMap<String, JobParameter> mapJobParameter = new HashMap<String, JobParameter>();
            for (Map.Entry<String, String> stringJobParameterEntry : this.optionJobParameters.entrySet()) {
                mapJobParameter.put(stringJobParameterEntry.getKey(), new JobParameter(stringJobParameterEntry.getValue()));
            }
            return new JobParameters(mapJobParameter);
        }
        return new JobParameters();
    }

    private Job getJob() {
        String jobName = this.option(this.optionJobName, DEFAULT_JOB_NAME);
        return (Job)this.injector.getInstance(Key.get(AbstractJob.class, (Annotation)Names.named((String)jobName)));
    }

    private JobLauncher getJobLauncher() {
        String jln = this.option(this.optionJobLauncherName, DEFAULT_JOB_LAUNCHER_NAME);
        return (JobLauncher)this.injector.getInstance(Key.get(JobLauncher.class, (Annotation)Names.named((String)jln)));
    }

    private String option(String option, String defaultName) {
        String ret = defaultName;
        if (!Strings.isNullOrEmpty((String)option)) {
            ret = option;
        }
        return ret;
    }
}

