/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.algorithm.myers;

import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.DiffAlgorithmFactory;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.algorithm.myers.PathNode;
import com.github.difflib.patch.DeltaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;

public final class MyersDiff<T>
implements DiffAlgorithmI<T> {
    private final BiPredicate<T, T> equalizer;

    public MyersDiff() {
        this.equalizer = Object::equals;
    }

    public MyersDiff(BiPredicate<T, T> equalizer) {
        Objects.requireNonNull(equalizer, "equalizer must not be null");
        this.equalizer = equalizer;
    }

    @Override
    public List<Change> computeDiff(List<T> source, List<T> target, DiffAlgorithmListener progress) {
        Objects.requireNonNull(source, "source list must not be null");
        Objects.requireNonNull(target, "target list must not be null");
        if (progress != null) {
            progress.diffStart();
        }
        PathNode path2 = this.buildPath(source, target, progress);
        List<Change> result = this.buildRevision(path2, source, target);
        if (progress != null) {
            progress.diffEnd();
        }
        return result;
    }

    private PathNode buildPath(List<T> orig, List<T> rev, DiffAlgorithmListener progress) {
        Objects.requireNonNull(orig, "original sequence is null");
        Objects.requireNonNull(rev, "revised sequence is null");
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new PathNode(0, -1, true, true, null);
        for (int d = 0; d < MAX; ++d) {
            if (progress != null) {
                progress.diffStep(d, MAX);
            }
            for (int k = -d; k <= d; k += 2) {
                int j;
                PathNode prev;
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                if (k == -d || k != d && diagonal[kminus].i < diagonal[kplus].i) {
                    i = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new PathNode(i, j, false, false, prev);
                for (j = i - k; i < N && j < M && this.equalizer.test(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i != node.i) {
                    node = new PathNode(i, j, true, false, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new IllegalStateException("could not find a diff path");
    }

    private List<Change> buildRevision(PathNode actualPath, List<T> orig, List<T> rev) {
        Objects.requireNonNull(actualPath, "path is null");
        Objects.requireNonNull(orig, "original sequence is null");
        Objects.requireNonNull(rev, "revised sequence is null");
        PathNode path2 = actualPath;
        ArrayList<Change> changes = new ArrayList<Change>();
        if (path2.isSnake()) {
            path2 = path2.prev;
        }
        while (path2 != null && path2.prev != null && path2.prev.j >= 0) {
            if (path2.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path2.i;
            int j = path2.j;
            path2 = path2.prev;
            int ianchor = path2.i;
            int janchor = path2.j;
            if (ianchor == i && janchor != j) {
                changes.add(new Change(DeltaType.INSERT, ianchor, i, janchor, j));
            } else if (ianchor != i && janchor == j) {
                changes.add(new Change(DeltaType.DELETE, ianchor, i, janchor, j));
            } else {
                changes.add(new Change(DeltaType.CHANGE, ianchor, i, janchor, j));
            }
            if (!path2.isSnake()) continue;
            path2 = path2.prev;
        }
        return changes;
    }

    public static DiffAlgorithmFactory factory() {
        return new DiffAlgorithmFactory(){

            @Override
            public <T> DiffAlgorithmI<T> create() {
                return new MyersDiff();
            }

            @Override
            public <T> DiffAlgorithmI<T> create(BiPredicate<T, T> equalizer) {
                return new MyersDiff<T>(equalizer);
            }
        };
    }
}

