/*
 * Decompiled with CFR 0.152.
 */
package xsbti;

public abstract class Maybe<t> {
    private Maybe() {
    }

    public static <s> Maybe<s> nothing() {
        return Nothing.INSTANCE;
    }

    public static <s> Maybe<s> just(s s) {
        return new Just<s>(s);
    }

    public final boolean isEmpty() {
        return !this.isDefined();
    }

    public abstract boolean isDefined();

    public abstract t get();

    public static final class Nothing
    extends Maybe<Object> {
        public static final Nothing INSTANCE = new Nothing();

        private Nothing() {
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("nothing.get");
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "Maybe.nothing()";
        }

        public boolean equals(Object object) {
            return this == object || object != null && object instanceof Nothing;
        }
    }

    public static final class Just<s>
    extends Maybe<s> {
        private final s v;

        public Just(s s) {
            this.v = s;
        }

        public s value() {
            return this.v;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public s get() {
            return this.v;
        }

        public int hashCode() {
            return 17 + (this.v == null ? 0 : this.v.hashCode());
        }

        public String toString() {
            return "Maybe.just(" + this.v + ")";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof Just)) {
                return false;
            }
            Just just = (Just)object;
            return this.v == null ? just.v == null : this.v.equals(just.v);
        }
    }
}

