/*
 * Decompiled with CFR 0.152.
 */
package xsbti;

public abstract class Maybe<t> {
    protected Maybe() {
    }

    public static <s> Maybe<s> just(final s s) {
        return new Maybe<s>(){

            @Override
            public boolean isDefined() {
                return true;
            }

            @Override
            public s get() {
                return s;
            }

            public int hashCode() {
                return 17 + (s == null ? 0 : s.hashCode());
            }

            public String toString() {
                return "Maybe.just(" + s + ")";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof Maybe)) {
                    return false;
                }
                Maybe maybe = (Maybe)object;
                if (!maybe.isDefined()) {
                    return false;
                }
                if (s == null) {
                    return maybe.get() == null;
                }
                return s.equals(maybe.get());
            }
        };
    }

    public static <s> Maybe<s> nothing() {
        return new Maybe<s>(){

            @Override
            public boolean isDefined() {
                return false;
            }

            @Override
            public s get() {
                throw new UnsupportedOperationException("nothing.get");
            }

            public int hashCode() {
                return 1;
            }

            public String toString() {
                return "Maybe.nothing()";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof Maybe)) {
                    return false;
                }
                Maybe maybe = (Maybe)object;
                return !maybe.isDefined();
            }
        };
    }

    public final boolean isEmpty() {
        return !this.isDefined();
    }

    public abstract boolean isDefined();

    public abstract t get();
}

