/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItem;

public final class XmlModuleDescriptorWriter {
    public static void write(ModuleDescriptor moduleDescriptor, File file) throws IOException {
        XmlModuleDescriptorWriter.write(moduleDescriptor, null, file);
    }

    public static void write(ModuleDescriptor moduleDescriptor, String charSequence, File object) throws IOException {
        if (((File)object).getParentFile() != null) {
            ((File)object).getParentFile().mkdirs();
        }
        object = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8"));
        try {
            ((PrintWriter)object).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (charSequence != null) {
                ((PrintWriter)object).print((String)charSequence);
            }
            charSequence = new StringBuffer();
            Object object2 = moduleDescriptor.getExtraAttributesNamespaces();
            for (Map.Entry entry : object2.entrySet()) {
                ((StringBuffer)charSequence).append(" xmlns:").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
            }
            object2 = "2.0";
            if (moduleDescriptor.getInheritedDescriptors().length > 0) {
                object2 = "2.2";
            }
            ((PrintWriter)object).println("<ivy-module version=\"" + (String)object2 + "\"" + charSequence + ">");
            XmlModuleDescriptorWriter.printInfoTag(moduleDescriptor, (PrintWriter)object);
            XmlModuleDescriptorWriter.printConfigurations(moduleDescriptor, (PrintWriter)object);
            XmlModuleDescriptorWriter.printPublications(moduleDescriptor, (PrintWriter)object);
            XmlModuleDescriptorWriter.printDependencies(moduleDescriptor, (PrintWriter)object);
            ((PrintWriter)object).println("</ivy-module>");
            return;
        }
        finally {
            ((PrintWriter)object).close();
        }
    }

    private static void printDependencies(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        if (dependencyDescriptorArray.length > 0) {
            printWriter.println("\t<dependencies>");
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[i];
                printWriter.print("\t\t");
                XmlModuleDescriptorWriter.printDependency(moduleDescriptor, dependencyDescriptor, printWriter);
            }
            XmlModuleDescriptorWriter.printAllExcludes(moduleDescriptor, printWriter);
            XmlModuleDescriptorWriter.printAllMediators(moduleDescriptor, printWriter);
            printWriter.println("\t</dependencies>");
        }
    }

    protected static void printDependency(ModuleDescriptor moduleDescriptor, DependencyDescriptor dependencyDescriptor, PrintWriter printWriter) {
        Object[] objectArray;
        printWriter.print("<dependency");
        printWriter.print(" org=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getOrganisation()) + "\"");
        printWriter.print(" name=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getName()) + "\"");
        if (dependencyDescriptor.getDependencyRevisionId().getBranch() != null) {
            printWriter.print(" branch=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getBranch()) + "\"");
        }
        printWriter.print(" rev=\"" + XMLHelper.escape(dependencyDescriptor.getDependencyRevisionId().getRevision()) + "\"");
        if (!dependencyDescriptor.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor.getDependencyRevisionId())) {
            if (dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getBranch() != null) {
                printWriter.print(" branchConstraint=\"" + XMLHelper.escape(dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getBranch()) + "\"");
            }
            printWriter.print(" revConstraint=\"" + XMLHelper.escape(dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision()) + "\"");
        }
        if (dependencyDescriptor.isForce()) {
            printWriter.print(" force=\"" + dependencyDescriptor.isForce() + "\"");
        }
        if (dependencyDescriptor.isChanging()) {
            printWriter.print(" changing=\"" + dependencyDescriptor.isChanging() + "\"");
        }
        if (!dependencyDescriptor.isTransitive()) {
            printWriter.print(" transitive=\"" + dependencyDescriptor.isTransitive() + "\"");
        }
        printWriter.print(" conf=\"");
        String[] stringArray = dependencyDescriptor.getModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = dependencyDescriptor.getDependencyConfigurations(stringArray[i]);
            printWriter.print(XMLHelper.escape(stringArray[i]) + "->");
            for (int j = 0; j < objectArray.length; ++j) {
                printWriter.print(XMLHelper.escape((String)objectArray[j]));
                if (j + 1 >= objectArray.length) continue;
                printWriter.print(",");
            }
            if (i + 1 >= stringArray.length) continue;
            printWriter.print(";");
        }
        printWriter.print("\"");
        XmlModuleDescriptorWriter.printExtraAttributes(dependencyDescriptor, printWriter, " ");
        DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray = dependencyDescriptor.getAllDependencyArtifacts();
        if (dependencyArtifactDescriptorArray.length > 0) {
            printWriter.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyArtefacts(moduleDescriptor, printWriter, dependencyArtifactDescriptorArray);
        objectArray = dependencyDescriptor.getAllIncludeRules();
        if (objectArray.length > 0 && dependencyArtifactDescriptorArray.length == 0) {
            printWriter.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyIncludeRules(moduleDescriptor, printWriter, (IncludeRule[])objectArray);
        ExcludeRule[] excludeRuleArray = dependencyDescriptor.getAllExcludeRules();
        if (excludeRuleArray.length > 0 && objectArray.length == 0 && dependencyArtifactDescriptorArray.length == 0) {
            printWriter.println(">");
        }
        XmlModuleDescriptorWriter.printDependencyExcludeRules(moduleDescriptor, printWriter, excludeRuleArray);
        if (objectArray.length + excludeRuleArray.length + dependencyArtifactDescriptorArray.length == 0) {
            printWriter.println("/>");
            return;
        }
        printWriter.println("\t\t</dependency>");
    }

    private static void printAllMediators(ModuleDescriptor iterator, PrintWriter printWriter) {
        iterator = iterator.getAllDependencyDescriptorMediators().getAllRules();
        for (Map.Entry entry : iterator.entrySet()) {
            MapMatcher mapMatcher = (MapMatcher)entry.getKey();
            DependencyDescriptorMediator dependencyDescriptorMediator = (DependencyDescriptorMediator)entry.getValue();
            if (dependencyDescriptorMediator instanceof OverrideDependencyDescriptorMediator) {
                OverrideDependencyDescriptorMediator overrideDependencyDescriptorMediator = (OverrideDependencyDescriptorMediator)dependencyDescriptorMediator;
                printWriter.print("\t\t<override");
                printWriter.print(" org=\"" + XMLHelper.escape((String)mapMatcher.getAttributes().get("organisation")) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape((String)mapMatcher.getAttributes().get("module")) + "\"");
                printWriter.print(" matcher=\"" + XMLHelper.escape(mapMatcher.getPatternMatcher().getName()) + "\"");
                if (overrideDependencyDescriptorMediator.getBranch() != null) {
                    printWriter.print(" branch=\"" + XMLHelper.escape(overrideDependencyDescriptorMediator.getBranch()) + "\"");
                }
                if (overrideDependencyDescriptorMediator.getVersion() != null) {
                    printWriter.print(" rev=\"" + XMLHelper.escape(overrideDependencyDescriptorMediator.getVersion()) + "\"");
                }
                printWriter.println("/>");
                continue;
            }
            Message.verbose("ignoring unhandled DependencyDescriptorMediator: " + dependencyDescriptorMediator.getClass());
        }
    }

    private static void printAllExcludes(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        ExcludeRule[] excludeRuleArray = moduleDescriptor.getAllExcludeRules();
        if (excludeRuleArray.length > 0) {
            for (int i = 0; i < excludeRuleArray.length; ++i) {
                printWriter.print("\t\t<exclude");
                printWriter.print(" org=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getOrganisation()) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getName()) + "\"");
                printWriter.print(" artifact=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = excludeRuleArray[i].getConfigurations();
                if (!Arrays.asList(stringArray).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(excludeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyExcludeRules(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, ExcludeRule[] excludeRuleArray) {
        if (excludeRuleArray.length > 0) {
            for (int i = 0; i < excludeRuleArray.length; ++i) {
                printWriter.print("\t\t\t<exclude");
                printWriter.print(" org=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getOrganisation()) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getName()) + "\"");
                printWriter.print(" name=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = excludeRuleArray[i].getConfigurations();
                if (!Arrays.asList(stringArray).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(excludeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyIncludeRules(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, IncludeRule[] includeRuleArray) {
        if (includeRuleArray.length > 0) {
            for (int i = 0; i < includeRuleArray.length; ++i) {
                printWriter.print("\t\t\t<include");
                printWriter.print(" name=\"" + XMLHelper.escape(includeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(includeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(includeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = includeRuleArray[i].getConfigurations();
                if (!Arrays.asList(stringArray).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(includeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyArtefacts(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray) {
        if (dependencyArtifactDescriptorArray.length > 0) {
            for (int i = 0; i < dependencyArtifactDescriptorArray.length; ++i) {
                printWriter.print("\t\t\t<artifact");
                printWriter.print(" name=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getExt()) + "\"");
                String[] stringArray = dependencyArtifactDescriptorArray[i].getConfigurations();
                if (!Arrays.asList(stringArray).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                XmlModuleDescriptorWriter.printExtraAttributes(dependencyArtifactDescriptorArray[i], printWriter, " ");
                printWriter.println("/>");
            }
        }
    }

    private static void printExtraAttributes(ExtendableItem extendableItem, PrintWriter printWriter, String string) {
        XmlModuleDescriptorWriter.printExtraAttributes(extendableItem.getQualifiedExtraAttributes(), printWriter, string);
    }

    private static void printExtraAttributes(Map object, PrintWriter printWriter, String string) {
        if (object == null) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            printWriter.print(string + entry.getKey() + "=\"" + XMLHelper.escape(entry.getValue().toString()) + "\"");
            string = " ";
        }
    }

    private static void printPublications(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        printWriter.println("\t<publications>");
        Artifact[] artifactArray = moduleDescriptor.getAllArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            printWriter.print("\t\t<artifact");
            printWriter.print(" name=\"" + XMLHelper.escape(artifactArray[i].getName()) + "\"");
            printWriter.print(" type=\"" + XMLHelper.escape(artifactArray[i].getType()) + "\"");
            printWriter.print(" ext=\"" + XMLHelper.escape(artifactArray[i].getExt()) + "\"");
            printWriter.print(" conf=\"" + XMLHelper.escape(XmlModuleDescriptorWriter.getConfs(moduleDescriptor, artifactArray[i])) + "\"");
            XmlModuleDescriptorWriter.printExtraAttributes(artifactArray[i], printWriter, " ");
            printWriter.println("/>");
        }
        printWriter.println("\t</publications>");
    }

    private static void printConfigurations(ModuleDescriptor configurationArray, PrintWriter printWriter) {
        if ((configurationArray = configurationArray.getConfigurations()).length > 0) {
            printWriter.println("\t<configurations>");
            for (int i = 0; i < configurationArray.length; ++i) {
                Configuration configuration = configurationArray[i];
                printWriter.print("\t\t");
                XmlModuleDescriptorWriter.printConfiguration(configuration, printWriter);
            }
            printWriter.println("\t</configurations>");
        }
    }

    protected static void printConfiguration(Configuration configuration, PrintWriter printWriter) {
        String[] stringArray;
        printWriter.print("<conf");
        printWriter.print(" name=\"" + XMLHelper.escape(configuration.getName()) + "\"");
        printWriter.print(" visibility=\"" + XMLHelper.escape(configuration.getVisibility().toString()) + "\"");
        if (configuration.getDescription() != null) {
            printWriter.print(" description=\"" + XMLHelper.escape(configuration.getDescription()) + "\"");
        }
        if ((stringArray = configuration.getExtends()).length > 0) {
            printWriter.print(" extends=\"");
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.print(XMLHelper.escape(stringArray[i]));
                if (i + 1 >= stringArray.length) continue;
                printWriter.print(",");
            }
            printWriter.print("\"");
        }
        if (!configuration.isTransitive()) {
            printWriter.println(" transitive=\"false\"");
        }
        if (configuration.getDeprecated() != null) {
            printWriter.print(" deprecated=\"" + XMLHelper.escape(configuration.getDeprecated()) + "\"");
        }
        XmlModuleDescriptorWriter.printExtraAttributes(configuration, printWriter, " ");
        printWriter.println("/>");
    }

    private static void printInfoTag(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        printWriter.println("\t<info organisation=\"" + XMLHelper.escape(moduleDescriptor.getModuleRevisionId().getOrganisation()) + "\"");
        printWriter.println("\t\tmodule=\"" + XMLHelper.escape(moduleDescriptor.getModuleRevisionId().getName()) + "\"");
        ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getResolvedModuleRevisionId().getBranch();
        if (extendsDescriptorArray != null) {
            printWriter.println("\t\tbranch=\"" + XMLHelper.escape((String)extendsDescriptorArray) + "\"");
        }
        if ((extendsDescriptorArray = moduleDescriptor.getResolvedModuleRevisionId().getRevision()) != null) {
            printWriter.println("\t\trevision=\"" + XMLHelper.escape((String)extendsDescriptorArray) + "\"");
        }
        printWriter.println("\t\tstatus=\"" + XMLHelper.escape(moduleDescriptor.getStatus()) + "\"");
        printWriter.println("\t\tpublication=\"" + DateUtil.format(moduleDescriptor.getResolvedPublicationDate()) + "\"");
        if (moduleDescriptor.isDefault()) {
            printWriter.println("\t\tdefault=\"true\"");
        }
        if (moduleDescriptor instanceof DefaultModuleDescriptor && (extendsDescriptorArray = (DefaultModuleDescriptor)moduleDescriptor).getNamespace() != null && !extendsDescriptorArray.getNamespace().getName().equals("system")) {
            printWriter.println("\t\tnamespace=\"" + XMLHelper.escape(extendsDescriptorArray.getNamespace().getName()) + "\"");
        }
        if (!moduleDescriptor.getExtraAttributes().isEmpty()) {
            XmlModuleDescriptorWriter.printExtraAttributes(moduleDescriptor, printWriter, "\t\t");
            printWriter.println();
        }
        if (XmlModuleDescriptorWriter.requireInnerInfoElement(moduleDescriptor)) {
            Map.Entry entry2;
            printWriter.println("\t>");
            extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
            for (int i = 0; i < extendsDescriptorArray.length; ++i) {
                ExtendsDescriptor extendsDescriptor = extendsDescriptorArray[i];
                entry2 = extendsDescriptor.getParentRevisionId();
                printWriter.print("\t\t<extends organisation=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry2)).getOrganisation()) + "\" module=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry2)).getName()) + "\" revision=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry2)).getRevision()) + "\"");
                entry2 = extendsDescriptor.getLocation();
                if (entry2 != null) {
                    printWriter.print(" location=\"" + XMLHelper.escape((String)((Object)entry2)) + "\"");
                }
                printWriter.print(" extendType=\"" + StringUtils.join(extendsDescriptor.getExtendsTypes(), ",") + "\"");
                printWriter.println("/>");
            }
            License[] licenseArray = moduleDescriptor.getLicenses();
            for (int i = 0; i < licenseArray.length; ++i) {
                entry2 = licenseArray[i];
                printWriter.print("\t\t<license ");
                if (((License)((Object)entry2)).getName() != null) {
                    printWriter.print("name=\"" + XMLHelper.escape(((License)((Object)entry2)).getName()) + "\" ");
                }
                if (((License)((Object)entry2)).getUrl() != null) {
                    printWriter.print("url=\"" + XMLHelper.escape(((License)((Object)entry2)).getUrl()) + "\" ");
                }
                printWriter.println("/>");
            }
            if (moduleDescriptor.getHomePage() != null || moduleDescriptor.getDescription() != null) {
                printWriter.print("\t\t<description");
                if (moduleDescriptor.getHomePage() != null) {
                    printWriter.print(" homepage=\"" + XMLHelper.escape(moduleDescriptor.getHomePage()) + "\"");
                }
                if (moduleDescriptor.getDescription() != null && moduleDescriptor.getDescription().trim().length() > 0) {
                    printWriter.println(">");
                    printWriter.println("\t\t" + XMLHelper.escape(moduleDescriptor.getDescription()));
                    printWriter.println("\t\t</description>");
                } else {
                    printWriter.println(" />");
                }
            }
            for (Map.Entry entry2 : moduleDescriptor.getExtraInfo().entrySet()) {
                if (entry2.getValue() == null || ((String)entry2.getValue()).length() == 0) continue;
                printWriter.print("\t\t<");
                printWriter.print(entry2.getKey());
                printWriter.print(">");
                printWriter.print(XMLHelper.escape((String)entry2.getValue()));
                printWriter.print("</");
                printWriter.print(entry2.getKey());
                printWriter.println(">");
            }
            printWriter.println("\t</info>");
            return;
        }
        printWriter.println("\t/>");
    }

    private static boolean requireInnerInfoElement(ModuleDescriptor moduleDescriptor) {
        return moduleDescriptor.getExtraInfo().size() > 0 || moduleDescriptor.getHomePage() != null || moduleDescriptor.getDescription() != null && moduleDescriptor.getDescription().trim().length() > 0 || moduleDescriptor.getLicenses().length > 0 || moduleDescriptor.getInheritedDescriptors().length > 0;
    }

    private static String getConfs(ModuleDescriptor moduleDescriptor, Artifact artifact) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = moduleDescriptor.getConfigurationsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Arrays.asList(moduleDescriptor.getArtifacts(stringArray[i])).contains(artifact)) continue;
            stringBuffer.append(stringArray[i]).append(",");
        }
        if (stringBuffer.length() > 0) {
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.setLength(stringBuffer2.length() - 1);
        }
        return stringBuffer.toString();
    }
}

