/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.compile.CompileProgress;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.PerClasspathEntryLookup;

public final class Setup
implements Serializable {
    private PerClasspathEntryLookup perClasspathEntryLookup;
    private boolean skip;
    private Path cachePath;
    private GlobalsCache cache;
    private IncOptions incrementalCompilerOptions;
    private Reporter reporter;
    private Optional<CompileProgress> progress;
    private T2<String, String>[] extra;

    public File cacheFile() {
        return this.cachePath.toFile();
    }

    public Setup withCacheFile(File file) {
        return this.withCachePath(file.toPath());
    }

    public static Setup create(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, file.toPath(), globalsCache, incOptions, reporter, optional, t2Array);
    }

    public static Setup of(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, file.toPath(), globalsCache, incOptions, reporter, optional, t2Array);
    }

    public static Setup create(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, Path path, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, path, globalsCache, incOptions, reporter, optional, t2Array);
    }

    public static Setup of(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, Path path, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, path, globalsCache, incOptions, reporter, optional, t2Array);
    }

    public static Setup create(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, Path path, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, CompileProgress compileProgress, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, path, globalsCache, incOptions, reporter, compileProgress, t2Array);
    }

    public static Setup of(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, Path path, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, CompileProgress compileProgress, T2<String, String>[] t2Array) {
        return new Setup(perClasspathEntryLookup, bl, path, globalsCache, incOptions, reporter, compileProgress, t2Array);
    }

    protected Setup(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, Path path, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, Optional<CompileProgress> optional, T2<String, String>[] t2Array) {
        this.perClasspathEntryLookup = perClasspathEntryLookup;
        this.skip = bl;
        this.cachePath = path;
        this.cache = globalsCache;
        this.incrementalCompilerOptions = incOptions;
        this.reporter = reporter;
        this.progress = optional;
        this.extra = t2Array;
    }

    protected Setup(PerClasspathEntryLookup perClasspathEntryLookup, boolean bl, Path path, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter, CompileProgress compileProgress, T2<String, String>[] t2Array) {
        this.perClasspathEntryLookup = perClasspathEntryLookup;
        this.skip = bl;
        this.cachePath = path;
        this.cache = globalsCache;
        this.incrementalCompilerOptions = incOptions;
        this.reporter = reporter;
        this.progress = Optional.ofNullable(compileProgress);
        this.extra = t2Array;
    }

    public PerClasspathEntryLookup perClasspathEntryLookup() {
        return this.perClasspathEntryLookup;
    }

    public boolean skip() {
        return this.skip;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    public GlobalsCache cache() {
        return this.cache;
    }

    public IncOptions incrementalCompilerOptions() {
        return this.incrementalCompilerOptions;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public Optional<CompileProgress> progress() {
        return this.progress;
    }

    public T2<String, String>[] extra() {
        return this.extra;
    }

    public Setup withPerClasspathEntryLookup(PerClasspathEntryLookup perClasspathEntryLookup) {
        return new Setup(perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra);
    }

    public Setup withSkip(boolean bl) {
        return new Setup(this.perClasspathEntryLookup, bl, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra);
    }

    public Setup withCachePath(Path path) {
        return new Setup(this.perClasspathEntryLookup, this.skip, path, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra);
    }

    public Setup withCache(GlobalsCache globalsCache) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, globalsCache, this.incrementalCompilerOptions, this.reporter, this.progress, this.extra);
    }

    public Setup withIncrementalCompilerOptions(IncOptions incOptions) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, incOptions, this.reporter, this.progress, this.extra);
    }

    public Setup withReporter(Reporter reporter) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, reporter, this.progress, this.extra);
    }

    public Setup withProgress(Optional<CompileProgress> optional) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, optional, this.extra);
    }

    public Setup withProgress(CompileProgress compileProgress) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, Optional.ofNullable(compileProgress), this.extra);
    }

    public Setup withExtra(T2<String, String>[] t2Array) {
        return new Setup(this.perClasspathEntryLookup, this.skip, this.cachePath, this.cache, this.incrementalCompilerOptions, this.reporter, this.progress, t2Array);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Setup)) {
            return false;
        }
        Setup setup = (Setup)object;
        return this.perClasspathEntryLookup().equals(setup.perClasspathEntryLookup()) && this.skip() == setup.skip() && this.cachePath().equals(setup.cachePath()) && this.cache().equals(setup.cache()) && this.incrementalCompilerOptions().equals(setup.incrementalCompilerOptions()) && this.reporter().equals(setup.reporter()) && this.progress().equals(setup.progress()) && Arrays.deepEquals(this.extra(), setup.extra());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.Setup".hashCode()) + this.perClasspathEntryLookup().hashCode()) + Boolean.valueOf(this.skip()).hashCode()) + this.cachePath().hashCode()) + this.cache().hashCode()) + this.incrementalCompilerOptions().hashCode()) + this.reporter().hashCode()) + this.progress().hashCode()) + Arrays.deepHashCode(this.extra()));
    }

    public String toString() {
        return "Setup(perClasspathEntryLookup: " + this.perClasspathEntryLookup() + ", skip: " + this.skip() + ", cachePath: " + this.cachePath() + ", cache: " + this.cache() + ", incrementalCompilerOptions: " + this.incrementalCompilerOptions() + ", reporter: " + this.reporter() + ", progress: " + this.progress() + ", extra: " + this.extra() + ")";
    }
}

