/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.renderers;

import com.vladsch.flexmark.util.ast.Node;
import dotty.tools.scaladoc.DRI;
import dotty.tools.scaladoc.DocContext;
import dotty.tools.scaladoc.DocContext$package$;
import dotty.tools.scaladoc.DocLink;
import dotty.tools.scaladoc.DocLink$ToDRI$;
import dotty.tools.scaladoc.DocLink$ToURL$;
import dotty.tools.scaladoc.DocLink$UnresolvedDRI$;
import dotty.tools.scaladoc.renderers.SignatureRenderer;
import dotty.tools.scaladoc.tasty.comments.markdown.DocFlexmarkRenderer$;
import dotty.tools.scaladoc.tasty.comments.markdown.SnippetRenderer$;
import dotty.tools.scaladoc.tasty.comments.wiki.Block;
import dotty.tools.scaladoc.tasty.comments.wiki.Bold;
import dotty.tools.scaladoc.tasty.comments.wiki.Bold$;
import dotty.tools.scaladoc.tasty.comments.wiki.Chain;
import dotty.tools.scaladoc.tasty.comments.wiki.Chain$;
import dotty.tools.scaladoc.tasty.comments.wiki.Code;
import dotty.tools.scaladoc.tasty.comments.wiki.Code$;
import dotty.tools.scaladoc.tasty.comments.wiki.ColumnOption;
import dotty.tools.scaladoc.tasty.comments.wiki.DefinitionList;
import dotty.tools.scaladoc.tasty.comments.wiki.DefinitionList$;
import dotty.tools.scaladoc.tasty.comments.wiki.HorizontalRule$;
import dotty.tools.scaladoc.tasty.comments.wiki.HtmlTag;
import dotty.tools.scaladoc.tasty.comments.wiki.HtmlTag$;
import dotty.tools.scaladoc.tasty.comments.wiki.Inline;
import dotty.tools.scaladoc.tasty.comments.wiki.Italic;
import dotty.tools.scaladoc.tasty.comments.wiki.Italic$;
import dotty.tools.scaladoc.tasty.comments.wiki.Link;
import dotty.tools.scaladoc.tasty.comments.wiki.Link$;
import dotty.tools.scaladoc.tasty.comments.wiki.Monospace;
import dotty.tools.scaladoc.tasty.comments.wiki.Monospace$;
import dotty.tools.scaladoc.tasty.comments.wiki.OrderedList;
import dotty.tools.scaladoc.tasty.comments.wiki.OrderedList$;
import dotty.tools.scaladoc.tasty.comments.wiki.Paragraph;
import dotty.tools.scaladoc.tasty.comments.wiki.Paragraph$;
import dotty.tools.scaladoc.tasty.comments.wiki.RepresentationLink;
import dotty.tools.scaladoc.tasty.comments.wiki.Row;
import dotty.tools.scaladoc.tasty.comments.wiki.Subscript;
import dotty.tools.scaladoc.tasty.comments.wiki.Subscript$;
import dotty.tools.scaladoc.tasty.comments.wiki.Summary;
import dotty.tools.scaladoc.tasty.comments.wiki.Summary$;
import dotty.tools.scaladoc.tasty.comments.wiki.Superscript;
import dotty.tools.scaladoc.tasty.comments.wiki.Superscript$;
import dotty.tools.scaladoc.tasty.comments.wiki.Table;
import dotty.tools.scaladoc.tasty.comments.wiki.Table$;
import dotty.tools.scaladoc.tasty.comments.wiki.Text;
import dotty.tools.scaladoc.tasty.comments.wiki.Text$;
import dotty.tools.scaladoc.tasty.comments.wiki.Title;
import dotty.tools.scaladoc.tasty.comments.wiki.Title$;
import dotty.tools.scaladoc.tasty.comments.wiki.Underline;
import dotty.tools.scaladoc.tasty.comments.wiki.Underline$;
import dotty.tools.scaladoc.tasty.comments.wiki.UnorderedList;
import dotty.tools.scaladoc.tasty.comments.wiki.UnorderedList$;
import dotty.tools.scaladoc.tasty.comments.wiki.WikiDocElement;
import dotty.tools.scaladoc.util.HTML$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.SortedMap;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DocRender {
    private final SignatureRenderer signatureRenderer;
    private final DocContext x$2;

    public DocRender(SignatureRenderer signatureRenderer, DocContext x$2) {
        this.signatureRenderer = signatureRenderer;
        this.x$2 = x$2;
    }

    public StringBuilder renderDocPart(Object doc) {
        Object object = doc;
        if (object instanceof Node) {
            Node node;
            Node md = node = (Node)object;
            return this.renderMarkdown(md);
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        Object object2 = object;
        if (!(nil$ != null ? !nil$.equals(object2) : object2 != null)) {
            return HTML$.MODULE$.raw("");
        }
        if (object instanceof Seq) {
            Object object3;
            Seq seq = (Seq)object;
            SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0 && (object3 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof WikiDocElement) {
                WikiDocElement wikiDocElement;
                WikiDocElement elem = wikiDocElement = (WikiDocElement)object3;
                return this.renderElement(elem);
            }
        }
        if (object instanceof Seq) {
            Seq seq;
            Seq list = seq = (Seq)object;
            return HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{list.map((Function1 & Serializable)e -> this.renderElement((WikiDocElement)e))}));
        }
        throw new MatchError(object);
    }

    private StringBuilder renderMarkdown(Node el) {
        return HTML$.MODULE$.raw(DocFlexmarkRenderer$.MODULE$.render(el, (Function2<DocLink, String, String>)(Function2 & Serializable)(link, name) -> this.renderLink((DocLink)link, (Function1<String, Object>)(Function1 & Serializable)string -> HTML$.MODULE$.text(name.isEmpty() ? string : name)).toString()));
    }

    private Seq<StringBuilder> listItems(Seq<WikiDocElement> items) {
        Seq<WikiDocElement> seq = items;
        Nil$ nil$ = package$.MODULE$.Nil();
        Seq<WikiDocElement> seq2 = seq;
        if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
            return package$.MODULE$.Nil();
        }
        if (seq instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)seq;
            WikiDocElement wikiDocElement = (WikiDocElement)colon2.head();
            List list = colon2.next();
            WikiDocElement x = wikiDocElement;
            if (list instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list;
                WikiDocElement wikiDocElement2 = (WikiDocElement)colon3.head();
                List list2 = colon3.next();
                if (wikiDocElement2 instanceof UnorderedList || wikiDocElement2 instanceof OrderedList) {
                    Serializable serializable;
                    Serializable y = serializable = (Serializable)((Object)wikiDocElement2);
                    List tail = list2;
                    StringBuilder stringBuilder = HTML$.MODULE$.li().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(x), this.renderElement((WikiDocElement)((Object)y))}));
                    return (Seq)this.listItems((Seq<WikiDocElement>)tail).$plus$colon((Object)stringBuilder);
                }
            }
            WikiDocElement x2 = wikiDocElement;
            List tail = list;
            StringBuilder stringBuilder = HTML$.MODULE$.li().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(x2)}));
            return (Seq)this.listItems((Seq<WikiDocElement>)tail).$plus$colon((Object)stringBuilder);
        }
        throw new MatchError(seq);
    }

    private StringBuilder notSupported(String name, StringBuilder content) {
        DocContext$package$.MODULE$.report().warning(() -> this.notSupported$$anonfun$1(name), DocContext$package$.MODULE$.report().warning$default$2(), DocContext$package$.MODULE$.compilerContext(this.x$2));
        return content;
    }

    private StringBuilder renderLink(DocLink target, Function1<String, Object> linkBody) {
        DocLink docLink = target;
        if (docLink instanceof DocLink.ToDRI) {
            DocLink.ToDRI toDRI = (DocLink.ToDRI)docLink;
            DocLink.ToDRI toDRI2 = DocLink$ToDRI$.MODULE$.unapply(toDRI);
            DRI dRI = toDRI2._1();
            String string = toDRI2._2();
            if (dRI != null) {
                DRI dRI2;
                DRI dri = dRI2 = dRI;
                if (string != null) {
                    String string2;
                    String name = string2 = string;
                    return this.signatureRenderer.renderLinkContent(linkBody.apply((Object)name), dri, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                }
            }
        }
        if (docLink instanceof DocLink.ToURL) {
            String string;
            DocLink.ToURL toURL = (DocLink.ToURL)docLink;
            DocLink.ToURL toURL2 = DocLink$ToURL$.MODULE$.unapply(toURL);
            String url = string = toURL2._1();
            return HTML$.MODULE$.a().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.href().$colon$eq(url)}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{linkBody.apply((Object)url)}));
        }
        if (docLink instanceof DocLink.UnresolvedDRI) {
            DocLink.UnresolvedDRI unresolvedDRI = (DocLink.UnresolvedDRI)docLink;
            DocLink.UnresolvedDRI unresolvedDRI2 = DocLink$UnresolvedDRI$.MODULE$.unapply(unresolvedDRI);
            String string = unresolvedDRI2._1();
            String string3 = unresolvedDRI2._2();
            String query = string;
            String msg = string3;
            String tooltip = "Problem linking " + query + ": " + msg;
            return this.signatureRenderer.unresolvedLink(linkBody.apply((Object)query), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HTML$.MODULE$.titleAttr().$colon$eq(tooltip)}));
        }
        throw new MatchError((Object)docLink);
    }

    private StringBuilder renderHeader(Row header) {
        return HTML$.MODULE$.tr().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{header.cells().map((Function1 & Serializable)c -> HTML$.MODULE$.th().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{c.blocks().map((Function1 & Serializable)e -> this.renderElement((WikiDocElement)e))})))}));
    }

    private StringBuilder renderRow(Row row) {
        return HTML$.MODULE$.tr().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{row.cells().map((Function1 & Serializable)c -> HTML$.MODULE$.td().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{c.blocks().map((Function1 & Serializable)e -> this.renderElement((WikiDocElement)e))})))}));
    }

    private StringBuilder renderElement(WikiDocElement e2) {
        WikiDocElement wikiDocElement;
        while (true) {
            Inline inline;
            Chain chain;
            Chain chain2;
            Seq<Inline> seq;
            Code code;
            Code code2;
            String string2;
            if ((wikiDocElement = e2) instanceof Title) {
                Title title = (Title)wikiDocElement;
                Title title2 = Title$.MODULE$.unapply(title);
                Inline inline2 = title2._1();
                int n = title2._2();
                Inline text = inline2;
                int level = n;
                StringBuilder content = this.renderElement(text);
                int n2 = level;
                switch (n2) {
                    case 1: {
                        return HTML$.MODULE$.h1().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("h600")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                    }
                    case 2: {
                        return HTML$.MODULE$.h2().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("h500")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                    }
                    case 3: {
                        return HTML$.MODULE$.h3().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("h400")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                    }
                    case 4: {
                        return HTML$.MODULE$.h4().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("h300")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                    }
                    case 5: {
                        return HTML$.MODULE$.h5().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("h200")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                    }
                    case 6: {
                        return HTML$.MODULE$.h6().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("h100")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{content}));
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
            if (wikiDocElement instanceof Paragraph) {
                Inline inline3;
                Paragraph paragraph = (Paragraph)wikiDocElement;
                Paragraph paragraph2 = Paragraph$.MODULE$.unapply(paragraph);
                Inline text = inline3 = paragraph2._1();
                return HTML$.MODULE$.p().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Code && (string2 = (code2 = Code$.MODULE$.unapply(code = (Code)wikiDocElement))._1()) != null) {
                String string3;
                String data = string3 = string2;
                return HTML$.MODULE$.raw(SnippetRenderer$.MODULE$.renderSnippet(data, SnippetRenderer$.MODULE$.renderSnippet$default$2()));
            }
            if (HorizontalRule$.MODULE$.equals(wikiDocElement)) {
                return HTML$.MODULE$.hr();
            }
            if (wikiDocElement instanceof Table) {
                Table table = (Table)wikiDocElement;
                Table table2 = Table$.MODULE$.unapply(table);
                Row row2 = table2._1();
                Seq<ColumnOption> seq2 = table2._2();
                Seq<Row> seq3 = table2._3();
                Row header = row2;
                Seq<ColumnOption> columns = seq2;
                Seq<Row> rows = seq3;
                return HTML$.MODULE$.table().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.thead().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderHeader(header)})), HTML$.MODULE$.tbody().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{rows.map((Function1 & Serializable)row -> this.renderRow((Row)row))}))}));
            }
            if (wikiDocElement instanceof UnorderedList) {
                Seq<Block> seq4;
                UnorderedList unorderedList = (UnorderedList)wikiDocElement;
                UnorderedList unorderedList2 = UnorderedList$.MODULE$.unapply(unorderedList);
                Seq<Block> items = seq4 = unorderedList2._1();
                return HTML$.MODULE$.ul().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.listItems(items)}));
            }
            if (wikiDocElement instanceof OrderedList) {
                OrderedList orderedList = (OrderedList)wikiDocElement;
                OrderedList orderedList2 = OrderedList$.MODULE$.unapply(orderedList);
                Seq<Block> seq5 = orderedList2._1();
                String string4 = orderedList2._2();
                Seq<Block> items = seq5;
                String style = string4;
                return HTML$.MODULE$.ol().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.listItems(items)}));
            }
            if (wikiDocElement instanceof Chain && (seq = (chain2 = Chain$.MODULE$.unapply(chain = (Chain)wikiDocElement))._1()) instanceof Seq) {
                Seq<Inline> seq6;
                Seq<Inline> items = seq6 = seq;
                return HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{items.map((Function1 & Serializable)e -> this.renderElement((WikiDocElement)e))}));
            }
            if (wikiDocElement instanceof Italic) {
                Inline inline4;
                Italic italic = (Italic)wikiDocElement;
                Italic italic2 = Italic$.MODULE$.unapply(italic);
                Inline text = inline4 = italic2._1();
                return HTML$.MODULE$.em().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Underline) {
                Inline inline5;
                Underline underline = (Underline)wikiDocElement;
                Underline underline2 = Underline$.MODULE$.unapply(underline);
                Inline text = inline5 = underline2._1();
                return HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("underline")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Bold) {
                Inline inline6;
                Bold bold = (Bold)wikiDocElement;
                Bold bold2 = Bold$.MODULE$.unapply(bold);
                Inline text = inline6 = bold2._1();
                return HTML$.MODULE$.strong().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Monospace) {
                Inline inline7;
                Monospace monospace = (Monospace)wikiDocElement;
                Monospace monospace2 = Monospace$.MODULE$.unapply(monospace);
                Inline text = inline7 = monospace2._1();
                return HTML$.MODULE$.code().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Superscript) {
                Inline inline8;
                Superscript superscript = (Superscript)wikiDocElement;
                Superscript superscript2 = Superscript$.MODULE$.unapply(superscript);
                Inline text = inline8 = superscript2._1();
                return HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("superscript")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Subscript) {
                Inline inline9;
                Subscript subscript = (Subscript)wikiDocElement;
                Subscript subscript2 = Subscript$.MODULE$.unapply(subscript);
                Inline text = inline9 = subscript2._1();
                return HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("subscript")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.renderElement(text)}));
            }
            if (wikiDocElement instanceof Link) {
                Link link = (Link)wikiDocElement;
                Link link2 = Link$.MODULE$.unapply(link);
                DocLink docLink = link2._1();
                Option<Inline> option = link2._2();
                DocLink target = docLink;
                Option<Inline> body = option;
                return this.renderLink(target, (Function1<String, Object>)(Function1 & Serializable)string -> body.fold(() -> DocRender.renderElement$$anonfun$3$$anonfun$1(string), (Function1 & Serializable)e -> this.renderElement((WikiDocElement)e)));
            }
            if (wikiDocElement instanceof Text) {
                String string5;
                Text text = (Text)wikiDocElement;
                Text text2 = Text$.MODULE$.unapply(text);
                String text3 = string5 = text2._1();
                return HTML$.MODULE$.raw(HTML$.MODULE$.escapeReservedTokens(text3));
            }
            if (!(wikiDocElement instanceof Summary)) break;
            Summary summary = (Summary)wikiDocElement;
            Summary summary2 = Summary$.MODULE$.unapply(summary);
            Inline text = inline = summary2._1();
            e2 = text;
        }
        if (wikiDocElement instanceof HtmlTag) {
            String string6;
            HtmlTag htmlTag = (HtmlTag)wikiDocElement;
            HtmlTag htmlTag2 = HtmlTag$.MODULE$.unapply(htmlTag);
            String content = string6 = htmlTag2._1();
            return HTML$.MODULE$.raw(content);
        }
        if (wikiDocElement instanceof DefinitionList) {
            SortedMap<Inline, Block> sortedMap;
            DefinitionList definitionList = (DefinitionList)wikiDocElement;
            DefinitionList definitionList2 = DefinitionList$.MODULE$.unapply(definitionList);
            SortedMap<Inline, Block> items = sortedMap = definitionList2._1();
            return this.notSupported("DefinitionList", HTML$.MODULE$.raw(""));
        }
        if (wikiDocElement instanceof RepresentationLink) {
            RepresentationLink representationLink;
            RepresentationLink link = representationLink = (RepresentationLink)wikiDocElement;
            return this.notSupported("Subscript", this.renderElement(link.title()));
        }
        throw new MatchError((Object)wikiDocElement);
    }

    private final String notSupported$$anonfun$1(String name$2) {
        return "Wiki syntax does not support " + name$2 + " in " + this.signatureRenderer.currentDri().location();
    }

    private static final Object renderElement$$anonfun$3$$anonfun$1(String default$1) {
        return default$1;
    }
}

