/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.parsers;

import com.vladsch.flexmark.ast.CodeBlock;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import dotty.tools.scaladoc.parsers.WikiCodeBlockParser$;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import scala.Predef$;

public class WikiCodeBlockParser
extends AbstractBlockParser {
    private int fenceLength;
    private int fenceIndent;
    private int fenceMarkerIndent;
    private final FencedCodeBlock block;
    private BlockContent content;
    private final Boolean codeContentBlock;

    public WikiCodeBlockParser(DataHolder options, int fenceLength, int fenceIndent, int fenceMarkerIndent) {
        this.fenceLength = fenceLength;
        this.fenceIndent = fenceIndent;
        this.fenceMarkerIndent = fenceMarkerIndent;
        this.fenceMarkerIndent_$eq(this.fenceIndent() + this.fenceMarkerIndent());
        this.block = new FencedCodeBlock();
        this.content = new BlockContent();
        this.codeContentBlock = (Boolean)options.get(Parser.FENCED_CODE_CONTENT_BLOCK);
    }

    public int fenceLength() {
        return this.fenceLength;
    }

    public void fenceLength_$eq(int x$1) {
        this.fenceLength = x$1;
    }

    private int fenceIndent() {
        return this.fenceIndent;
    }

    private void fenceIndent_$eq(int x$0) {
        this.fenceIndent = x$0;
    }

    private int fenceMarkerIndent() {
        return this.fenceMarkerIndent;
    }

    private void fenceMarkerIndent_$eq(int x$0) {
        this.fenceMarkerIndent = x$0;
    }

    public final FencedCodeBlock dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block() {
        return this.block;
    }

    public Block getBlock() {
        return this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block();
    }

    public int getFenceIndent() {
        return this.fenceIndent();
    }

    public int getFenceMarkerIndent() {
        return this.fenceMarkerIndent();
    }

    public BlockContinue tryContinue(ParserState state) {
        int foundFenceLength;
        BasedSequence trySequence;
        boolean matches;
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        BasedSequence line = state.getLine();
        Matcher matcher = null;
        boolean bl = matches = state.getIndent() <= 3 && nextNonSpace < line.length();
        if (matches && (matcher = WikiCodeBlockParser$.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$$CLOSING_FENCE.matcher((CharSequence)(trySequence = line.subSequence(nextNonSpace, line.length())))).find() && (foundFenceLength = matcher.group(0).length()) >= this.fenceLength()) {
            this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setClosingMarker(trySequence.subSequence(0, foundFenceLength));
            return BlockContinue.finished();
        }
        for (int i = this.fenceIndent(); i > 0 && newIndex < line.length() && line.charAt(newIndex) == ' '; ++newIndex, --i) {
        }
        return BlockContinue.atIndex((int)newIndex);
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    public void closeBlock(ParserState state) {
        List lines = this.content.getLines();
        if (lines.size() > 0) {
            BasedSequence info = (BasedSequence)lines.get(0);
            if (!info.isBlank()) {
                this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setInfo(info.trim());
            }
            BasedSequence chars = this.content.getSpanningChars();
            BasedSequence spanningChars = chars.baseSubSequence(chars.getStartOffset(), ((BasedSequence)lines.get(0)).getEndOffset());
            if (lines.size() > 1) {
                List segments = lines.subList(1, lines.size());
                this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setContent(spanningChars, segments);
                if (Predef$.MODULE$.Boolean2boolean(this.codeContentBlock)) {
                    CodeBlock codeBlock = new CodeBlock();
                    codeBlock.setContent(segments);
                    codeBlock.setCharsFromContent();
                    this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().appendChild((Node)codeBlock);
                } else {
                    Text codeBlock = new Text(SegmentedSequence.of(segments));
                    this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().appendChild((Node)codeBlock);
                }
            } else {
                this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setContent(spanningChars, BasedSequence.EMPTY_LIST);
            }
        } else {
            this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setContent(this.content);
        }
        this.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setCharsFromContent();
        this.content = null;
    }

    public static class BlockFactory
    extends AbstractBlockParserFactory {
        private final DataHolder options;

        public BlockFactory(DataHolder options) {
            this.options = options;
            super(options);
        }

        public DataHolder options() {
            return this.options;
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence trySequence;
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence line = state.getLine();
            Matcher matcher = null;
            if (state.getIndent() < 4 && (matcher = WikiCodeBlockParser$.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$$OPENING_FENCE.matcher((CharSequence)(trySequence = line.subSequence(nextNonSpace, line.length())))).find()) {
                int fenceLength = matcher.group(0).length();
                WikiCodeBlockParser blockParser = new WikiCodeBlockParser((DataHolder)state.getProperties(), fenceLength, state.getIndent(), nextNonSpace);
                blockParser.dotty$tools$scaladoc$parsers$WikiCodeBlockParser$$block().setOpeningMarker(trySequence.subSequence(0, fenceLength));
                return BlockStart.of((BlockParser[])new BlockParser[]{blockParser}).atIndex(nextNonSpace + fenceLength);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public HashSet<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class));
        }

        public HashSet<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

