/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.tasty.comments.markdown;

import dotty.tools.scaladoc.snippets.MessageLevel;
import dotty.tools.scaladoc.snippets.MessageLevel$;
import dotty.tools.scaladoc.snippets.Position;
import dotty.tools.scaladoc.snippets.SnippetCompilerMessage;
import dotty.tools.scaladoc.tasty.comments.markdown.ExtendedFencedCodeBlock;
import dotty.tools.scaladoc.tasty.comments.markdown.SnippetLine;
import dotty.tools.scaladoc.tasty.comments.markdown.SnippetLine$;
import dotty.tools.scaladoc.util.HTML$;
import dotty.tools.scaladoc.util.HTML$Attr$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class SnippetRenderer$
implements Serializable {
    private static final String hiddenStartSymbol;
    private static final String hiddenEndSymbol;
    private static final String importedStartSymbol;
    private static final String importedEndSymbol;
    private static final Regex importedRegex;
    public static final SnippetRenderer$ MODULE$;

    private SnippetRenderer$() {
    }

    static {
        MODULE$ = new SnippetRenderer$();
        hiddenStartSymbol = "//{";
        hiddenEndSymbol = "//}";
        importedStartSymbol = "//{i";
        importedEndSymbol = "//i}";
        importedRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\/\\/\\{i:(.*)"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SnippetRenderer$.class);
    }

    public String hiddenStartSymbol() {
        return hiddenStartSymbol;
    }

    public String hiddenEndSymbol() {
        return hiddenEndSymbol;
    }

    public String importedStartSymbol() {
        return importedStartSymbol;
    }

    public String importedEndSymbol() {
        return importedEndSymbol;
    }

    public Regex importedRegex() {
        return importedRegex;
    }

    private String compileMessageCSSClass(SnippetCompilerMessage msg) {
        MessageLevel messageLevel = msg.level();
        MessageLevel messageLevel2 = MessageLevel$.Info;
        MessageLevel messageLevel3 = messageLevel;
        if (!(messageLevel2 != null ? !messageLevel2.equals(messageLevel3) : messageLevel3 != null)) {
            return "snippet-info";
        }
        MessageLevel messageLevel4 = MessageLevel$.Warning;
        MessageLevel messageLevel5 = messageLevel;
        if (!(messageLevel4 != null ? !messageLevel4.equals(messageLevel5) : messageLevel5 != null)) {
            return "snippet-warn";
        }
        MessageLevel messageLevel6 = MessageLevel$.Error;
        MessageLevel messageLevel7 = messageLevel;
        if (!(messageLevel6 != null ? !messageLevel6.equals(messageLevel7) : messageLevel7 != null)) {
            return "snippet-error";
        }
        MessageLevel messageLevel8 = MessageLevel$.Debug;
        MessageLevel messageLevel9 = messageLevel;
        if (!(messageLevel8 != null ? !messageLevel8.equals(messageLevel9) : messageLevel9 != null)) {
            return "snippet-debug";
        }
        throw new MatchError((Object)messageLevel);
    }

    private <A> Option<A> cutBetweenSymbols(String startSymbol, String endSymbol, Seq<SnippetLine> snippetLines, Function3<Seq<SnippetLine>, Seq<SnippetLine>, Seq<SnippetLine>, A> f) {
        return ((IterableOnceOps)snippetLines.zipWithIndex()).find((Function1 & Serializable)_$2 -> ((SnippetLine)_$2._1()).content().contains(startSymbol)).map((Function1 & Serializable)_$3 -> BoxesRunTime.unboxToInt((Object)_$3._2())).flatMap((Function1 & Serializable)startIdx -> this.cutBetweenSymbols$$anonfun$3(endSymbol, snippetLines, f, BoxesRunTime.unboxToInt((Object)startIdx)));
    }

    private Seq<SnippetLine> wrapImportedSection(Seq<SnippetLine> snippetLines) {
        Option mRes = this.cutBetweenSymbols(this.importedStartSymbol(), this.importedEndSymbol(), snippetLines, (Function3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 != null) {
                Seq begin = (Seq)tuple3._1();
                Seq mid = (Seq)tuple3._2();
                Seq end = (Seq)tuple3._3();
                String name = (String)this.importedRegex().findFirstMatchIn((CharSequence)((SnippetLine)mid.head()).content()).fold(this::$anonfun$3, (Function1 & Serializable)_$6 -> _$6.group(1));
                return (Seq)((IterableOps)begin.$plus$plus((IterableOnce)((IterableOps)((IterableOps)mid.drop(1)).dropRight(1)).map((Function1 & Serializable)_$7 -> _$7.withClass("hideable").withClass("include").withAttribute("name", name)))).$plus$plus(this.wrapImportedSection((Seq<SnippetLine>)end));
            }
            throw new MatchError((Object)tuple3);
        });
        return (Seq)mRes.getOrElse(() -> this.wrapImportedSection$$anonfun$1(snippetLines));
    }

    private Seq<SnippetLine> wrapHiddenSymbols(Seq<SnippetLine> snippetLines) {
        Option mRes = this.cutBetweenSymbols(this.hiddenStartSymbol(), this.hiddenEndSymbol(), snippetLines, (Function3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 != null) {
                Seq begin = (Seq)tuple3._1();
                Seq mid = (Seq)tuple3._2();
                Seq end = (Seq)tuple3._3();
                return (Seq)((IterableOps)begin.$plus$plus((IterableOnce)((IterableOps)((IterableOps)mid.drop(1)).dropRight(1)).map((Function1 & Serializable)_$8 -> _$8.withClass("hideable")))).$plus$plus(this.wrapHiddenSymbols((Seq<SnippetLine>)end));
            }
            throw new MatchError((Object)tuple3);
        });
        return (Seq)mRes.getOrElse(() -> this.wrapHiddenSymbols$$anonfun$1(snippetLines));
    }

    private Seq<SnippetLine> wrapCommonIndent(Seq<SnippetLine> snippetLines) {
        Seq nonHiddenSnippetLines = (Seq)snippetLines.filter((Function1 & Serializable)l -> !l.classes().contains((Object)"hideable"));
        return (Seq)nonHiddenSnippetLines.headOption().map((Function1 & Serializable)_$9 -> StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(_$9.content()), (Function1 & Serializable)_$10 -> this.wrapCommonIndent$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$10)))).map((Function1 & Serializable)prefix -> {
            String maxCommonIndent = (String)nonHiddenSnippetLines.foldLeft(prefix, (Function2 & Serializable)(currPrefix, elem) -> {
                if (elem.content().startsWith((String)currPrefix)) {
                    return currPrefix;
                }
                return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(elem.content()), (Function1 & Serializable)_$11 -> this.$anonfun$7$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$11)));
            });
            return (Seq)snippetLines.map((Function1 & Serializable)line -> {
                if (line.classes().contains((Object)"hideable") || StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(maxCommonIndent)) == 0) {
                    return line;
                }
                return line.copy(new StringBuilder(0).append(HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("hideable")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{maxCommonIndent})).toString()).append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(line.content()), maxCommonIndent)).toString(), line.copy$default$2(), line.copy$default$3(), line.copy$default$4(), line.copy$default$5());
            });
        }).getOrElse(() -> this.wrapCommonIndent$$anonfun$3(snippetLines));
    }

    private SnippetLine wrapLineInBetween(Option<String> startSymbol, Option<String> endSymbol, SnippetLine line) {
        Option endIdx;
        Option startIdx = startSymbol.map((Function1 & Serializable)s -> line.content().indexOf((String)s));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)startIdx, (Object)(endIdx = endSymbol.map((Function1 & Serializable)s -> line.content().indexOf((String)s))));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                int idx = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (None$.MODULE$.equals(option2)) {
                    String comment;
                    Tuple2 tuple22 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line.content()), idx);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    String code = (String)tuple22._1();
                    String comment2 = (String)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)code, (Object)comment2);
                    String code2 = (String)tuple23._1();
                    String string = comment = (String)tuple23._2();
                    if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(code2), (Function1 & Serializable)_$12 -> this.wrapLineInBetween$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$12)))) {
                        return line.withClass("hideable");
                    }
                    if (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(comment)) == '\n') {
                        return line.copy(new StringBuilder(0).append(code2).append(new StringBuilder(31).append("<span class=\"hideable\">").append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(comment), 1)).append("</span>").append("\n").toString()).toString(), line.copy$default$2(), line.copy$default$3(), line.copy$default$4(), line.copy$default$5());
                    }
                    return line.copy(new StringBuilder(0).append(code2).append(new StringBuilder(30).append("<span class=\"hideable\">").append(comment).append("</span>").toString()).toString(), line.copy$default$2(), line.copy$default$3(), line.copy$default$4(), line.copy$default$5());
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                int idx = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                Tuple2 tuple24 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line.content()), idx + StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)endSymbol.get())));
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                String comment = (String)tuple24._1();
                String code = (String)tuple24._2();
                Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)comment, (Object)code);
                String comment3 = (String)tuple25._1();
                String code3 = (String)tuple25._2();
                String string = comment3;
                if (StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(code3), (Function1 & Serializable)_$13 -> this.wrapLineInBetween$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$13)))) {
                    return line.withClass("hideable");
                }
                return line.copy(new StringBuilder(30).append("<span class=\"hideable\">").append(comment3).append("</span>").append(code3).toString(), line.copy$default$2(), line.copy$default$3(), line.copy$default$4(), line.copy$default$5());
            }
            if (option instanceof Some) {
                int startIdx2 = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    int endIdx2 = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    Tuple2 tuple26 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(line.content()), endIdx2 + StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)endSymbol.get())));
                    if (tuple26 == null) {
                        throw new MatchError((Object)tuple26);
                    }
                    String tmp = (String)tuple26._1();
                    String end = (String)tuple26._2();
                    Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)tmp, (Object)end);
                    String tmp2 = (String)tuple27._1();
                    String end2 = (String)tuple27._2();
                    Tuple2 tuple28 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(tmp2), startIdx2);
                    if (tuple28 == null) {
                        throw new MatchError((Object)tuple28);
                    }
                    String begin = (String)tuple28._1();
                    String comment = (String)tuple28._2();
                    Tuple2 tuple29 = Tuple2$.MODULE$.apply((Object)begin, (Object)comment);
                    String begin2 = (String)tuple29._1();
                    String comment4 = (String)tuple29._2();
                    return line.copy(new StringBuilder(0).append(begin2).append(new StringBuilder(30).append("<span class=\"hideable\">").append(comment4).append("</span>").toString()).append(end2).toString(), line.copy$default$2(), line.copy$default$3(), line.copy$default$4(), line.copy$default$5());
                }
            }
        }
        return line;
    }

    private Seq<SnippetLine> wrapCodeLines(Seq<String> codeLines) {
        Seq snippetLines2 = (Seq)((IterableOps)codeLines.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String content = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return SnippetLine$.MODULE$.apply(HTML$.MODULE$.escapeReservedTokens(content), idx, SnippetLine$.MODULE$.$lessinit$greater$default$3(), SnippetLine$.MODULE$.$lessinit$greater$default$4(), SnippetLine$.MODULE$.$lessinit$greater$default$5());
            }
            throw new MatchError((Object)tuple2);
        });
        return (Seq)((Function1 & Serializable)(Function1 & Serializable)snippetLines -> this.wrapImportedSection((Seq<SnippetLine>)snippetLines)).andThen((Function1 & Serializable)snippetLines -> this.wrapHiddenSymbols((Seq<SnippetLine>)snippetLines)).andThen((Function1 & Serializable)snippetLines -> this.wrapCommonIndent((Seq<SnippetLine>)snippetLines)).apply((Object)snippetLines2);
    }

    private Seq<SnippetLine> addCompileMessages(Seq<SnippetCompilerMessage> messages, Seq<SnippetLine> codeLines) {
        Map messagesDict = ((IterableOps)messages.filter((Function1 & Serializable)_$14 -> _$14.position().nonEmpty())).groupBy((Function1 & Serializable)_$15 -> ((Position)_$15.position().get()).relativeLine()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Seq)codeLines.map((Function1 & Serializable)line -> {
            Option option = messagesDict.get((Object)BoxesRunTime.boxToInteger((int)line.lineNo()));
            if (None$.MODULE$.equals(option)) {
                return line;
            }
            if (option instanceof Some) {
                Seq messages = (Seq)((Some)option).value();
                List classes = (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{messages.find((Function1 & Serializable)_$16 -> {
                    MessageLevel messageLevel = _$16.level();
                    MessageLevel messageLevel2 = MessageLevel$.Error;
                    return !(messageLevel != null ? !messageLevel.equals(messageLevel2) : messageLevel2 != null);
                }).map((Function1 & Serializable)msg -> this.compileMessageCSSClass((SnippetCompilerMessage)msg)), messages.find((Function1 & Serializable)_$17 -> {
                    MessageLevel messageLevel = _$17.level();
                    MessageLevel messageLevel2 = MessageLevel$.Warning;
                    return !(messageLevel != null ? !messageLevel.equals(messageLevel2) : messageLevel2 != null);
                }).map((Function1 & Serializable)msg -> this.compileMessageCSSClass((SnippetCompilerMessage)msg)), messages.find((Function1 & Serializable)_$18 -> {
                    MessageLevel messageLevel = _$18.level();
                    MessageLevel messageLevel2 = MessageLevel$.Info;
                    return !(messageLevel != null ? !messageLevel.equals(messageLevel2) : messageLevel2 != null);
                }).map((Function1 & Serializable)msg -> this.compileMessageCSSClass((SnippetCompilerMessage)msg))}))).flatten(Predef$.MODULE$.$conforms());
                Set set = (Set)line.classes().$plus$plus((IterableOnce)classes.toSet()).$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tooltip"})));
                Seq seq = (Seq)messages.map((Function1 & Serializable)_$19 -> _$19.message());
                String string = line.copy$default$1();
                int n = line.copy$default$2();
                Map<String, String> map = line.copy$default$5();
                return line.copy(string, n, (Set<String>)set, (Seq<String>)seq, map);
            }
            throw new MatchError((Object)option);
        });
    }

    private String messagesHTML(Seq<SnippetCompilerMessage> messages) {
        if (messages.isEmpty()) {
            return "";
        }
        String content = ((IterableOnceOps)messages.map((Function1 & Serializable)msg -> new StringBuilder(22).append("<span class=\"").append(this.compileMessageCSSClass((SnippetCompilerMessage)msg)).append("\">").append(msg.message()).append("</span>").toString())).mkString("<br>");
        return new StringBuilder(4).append("<hr>").append(content).toString();
    }

    private String snippetLabel(String name) {
        return HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("snippet-meta")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("snippet-label")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{name}))})).toString();
    }

    public String renderSnippetWithMessages(Option<String> snippetName, Seq<String> codeLines2, Seq<SnippetCompilerMessage> messages, boolean hasContext, boolean success) {
        Seq transformedLines = (Seq)((IterableOps)((Function1 & Serializable)(Function1 & Serializable)codeLines -> this.wrapCodeLines((Seq<String>)codeLines)).andThen((Function1 & Serializable)codeLines -> this.addCompileMessages(messages, (Seq<SnippetLine>)codeLines)).apply(codeLines2)).map((Function1 & Serializable)_$20 -> _$20.toHTML());
        String codeHTML = new StringBuilder(36).append("<code class=\"language-scala\">").append(transformedLines.mkString("")).append("</code>").toString();
        boolean isRunnable = !hasContext && success;
        Seq attrs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Option$.MODULE$.when(isRunnable, this::$anonfun$24)})).flatten(Predef$.MODULE$.$conforms());
        return HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("snippet"), HTML$Attr$.MODULE$.apply("scala-snippet").$colon$eq(""), attrs}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.cls().$colon$eq("buttons")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[0])), HTML$.MODULE$.pre().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.raw(codeHTML)})), HTML$.MODULE$.raw((String)snippetName.fold(this::renderSnippetWithMessages$$anonfun$1, (Function1 & Serializable)_$21 -> this.snippetLabel((String)_$21)))})).toString();
    }

    public String renderSnippetWithMessages(ExtendedFencedCodeBlock node) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])node.codeBlock().getContentChars().toString().split("\n"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$22 -> new StringBuilder(1).append((String)_$22).append("\n").toString(), ClassTag$.MODULE$.apply(String.class)));
        return this.renderSnippetWithMessages(node.name(), (Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object2), (Seq<SnippetCompilerMessage>)((Seq)Option$.MODULE$.option2Iterable(node.compilationResult()).toSeq().flatMap((Function1 & Serializable)_$23 -> _$23.messages())), node.hasContext(), BoxesRunTime.unboxToBoolean((Object)node.compilationResult().fold(this::renderSnippetWithMessages$$anonfun$5, (Function1 & Serializable)_$24 -> _$24.isSuccessful())));
    }

    private final /* synthetic */ Tuple3 cutBetweenSymbols$$anonfun$3$$anonfun$3(Seq snippetLines$2, int startIdx$1, int endIdx) {
        Tuple2 tuple2 = snippetLines$2.splitAt(endIdx + 1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq tmp = (Seq)tuple2._1();
        Seq end = (Seq)tuple2._2();
        Tuple2 $1$ = tuple2;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)tmp, (Object)end);
        Tuple2 $1$2 = (Tuple2)tuple3._1();
        Seq tmp2 = (Seq)tuple3._2();
        Seq end2 = (Seq)tuple3._3();
        Tuple2 tuple22 = tmp2.splitAt(startIdx$1);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Seq begin = (Seq)tuple22._1();
        Seq mid = (Seq)tuple22._2();
        Tuple2 $2$ = tuple22;
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)$2$, (Object)begin, (Object)mid);
        Tuple2 $2$2 = (Tuple2)tuple32._1();
        Seq begin2 = (Seq)tuple32._2();
        Seq mid2 = (Seq)tuple32._3();
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)endIdx), (Object)$1$2, (Object)$2$2);
    }

    private final /* synthetic */ Option cutBetweenSymbols$$anonfun$3(String endSymbol$1, Seq snippetLines$1, Function3 f$1, int startIdx) {
        return ((IterableOnceOps)snippetLines$1.zipWithIndex()).find((Function1 & Serializable)_$4 -> ((SnippetLine)_$4._1()).content().contains(endSymbol$1)).map((Function1 & Serializable)_$5 -> BoxesRunTime.unboxToInt((Object)_$5._2())).map((Function1 & Serializable)endIdx -> this.cutBetweenSymbols$$anonfun$3$$anonfun$3(snippetLines$1, startIdx, BoxesRunTime.unboxToInt((Object)endIdx))).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Tuple2 tuple2 = (Tuple2)tuple3._2();
                Tuple2 tuple22 = (Tuple2)tuple3._3();
                int endIdx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                if (tuple2 != null) {
                    Seq tmp = (Seq)tuple2._1();
                    Seq end = (Seq)tuple2._2();
                    if (tuple22 != null) {
                        Seq begin = (Seq)tuple22._1();
                        Seq mid = (Seq)tuple22._2();
                        return f$1.apply((Object)begin, (Object)mid, (Object)end);
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private final String $anonfun$3() {
        return "";
    }

    private final Seq wrapImportedSection$$anonfun$1(Seq snippetLines$3) {
        return snippetLines$3;
    }

    private final Seq wrapHiddenSymbols$$anonfun$1(Seq snippetLines$4) {
        return snippetLines$4;
    }

    private final /* synthetic */ boolean wrapCommonIndent$$anonfun$1$$anonfun$1(char _$10) {
        return _$10 == ' ';
    }

    private final /* synthetic */ boolean $anonfun$7$$anonfun$1(char _$11) {
        return _$11 == ' ';
    }

    private final Seq wrapCommonIndent$$anonfun$3(Seq snippetLines$6) {
        return snippetLines$6;
    }

    private final /* synthetic */ boolean wrapLineInBetween$$anonfun$1(char _$12) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$12));
    }

    private final /* synthetic */ boolean wrapLineInBetween$$anonfun$2(char _$13) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$13));
    }

    private final String $anonfun$24() {
        return HTML$Attr$.MODULE$.apply("runnable").$colon$eq("");
    }

    private final String renderSnippetWithMessages$$anonfun$1() {
        return "";
    }

    private final boolean renderSnippetWithMessages$$anonfun$5() {
        return false;
    }
}

