/*
 * Decompiled with CFR 0.152.
 */
package dotty.dokka;

import dotty.dokka.PrefixedSourceLink;
import dotty.dokka.PrefixedSourceLink$;
import dotty.dokka.SourceLink;
import dotty.dokka.TemplateSourceLink$;
import dotty.dokka.WebBasedSourceLink$;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class SourceLink$
implements Serializable {
    private static final Regex SubPath;
    private static final Regex KnownProvider;
    private static final Regex BrokenKnownProvider;
    private static final Regex ScalaDocPatten;
    private static final Map SupportedScalaDocPatternReplacements;
    public static final SourceLink$ MODULE$;

    private SourceLink$() {
    }

    static {
        MODULE$ = new SourceLink$();
        SubPath = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^=]+)=(.+)"));
        KnownProvider = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\w+):\\/\\/([^\\/#]+)\\/([^\\/#]+)(\\/[^\\/#]+)?(#.+)?"));
        BrokenKnownProvider = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\w+):\\/\\/.+"));
        ScalaDocPatten = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\u20ac\\{(TPL_NAME|TPL_OWNER|FILE_PATH|FILE_EXT|FILE_LINE|FILE_PATH_EXT)\\}"));
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_PATH_EXT}");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"{{ path }}");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_LINE}");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"{{ line }}");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{TPL_NAME}");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"{{ name }}");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_EXT}");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"{{ ext }}");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_PATH}");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"{{ path_no_ext }}");
        SupportedScalaDocPatternReplacements = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceLink$.class);
    }

    public Regex SubPath() {
        return SubPath;
    }

    public Regex KnownProvider() {
        return KnownProvider;
    }

    public Regex BrokenKnownProvider() {
        return BrokenKnownProvider;
    }

    public Regex ScalaDocPatten() {
        return ScalaDocPatten;
    }

    public Map<String, String> SupportedScalaDocPatternReplacements() {
        return SupportedScalaDocPatternReplacements;
    }

    public String githubPrefix(String org, String repo) {
        return "https://github.com/" + org + "/" + repo;
    }

    public String gitlabPrefix(String org, String repo) {
        return "https://gitlab.com/" + org + "/" + repo + "/-";
    }

    private Option<SourceLink> parseLinkDefinition(String s) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Either<String, SourceLink> parse(String string, Option<String> revision) {
        Right right;
        String string2 = string;
        if (string2 != null) {
            String string3;
            List list;
            List list2;
            List list3;
            Option option = this.KnownProvider().unapplySeq((CharSequence)string2);
            if (!option.isEmpty() && (list3 = (List)option.get()).lengthCompare(5) == 0) {
                String string4 = (String)list3.apply(0);
                String string5 = (String)list3.apply(1);
                String string6 = (String)list3.apply(2);
                String string7 = (String)list3.apply(3);
                String string8 = (String)list3.apply(4);
                String name = string4;
                String organization = string5;
                String repo = string6;
                String rawRevision = string7;
                String rawSubPath = string8;
                String subPath = (String)Option$.MODULE$.apply((Object)rawSubPath).fold(this::$anonfun$1, (Function1 & Serializable)_$4 -> "/" + StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$4), 1));
                Option pathRev = Option$.MODULE$.apply((Object)rawRevision).map((Function1 & Serializable)_$5 -> StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$5), 1)).orElse(() -> this.$anonfun$4(revision));
                String string9 = name;
                if ("github".equals(string9)) {
                    right = this.withRevision$1(pathRev, (Function1 & Serializable)rev -> WebBasedSourceLink$.MODULE$.apply(this.githubPrefix(organization, repo), (String)rev, subPath));
                    return right;
                }
                if ("gitlab".equals(string9)) {
                    right = this.withRevision$1(pathRev, (Function1 & Serializable)rev -> WebBasedSourceLink$.MODULE$.apply(this.gitlabPrefix(organization, repo), (String)rev, subPath));
                    return right;
                }
                String other = string9;
                right = package$.MODULE$.Left().apply((Object)("'" + other + "' is not a known provider, please provide full source path template."));
                return right;
            }
            Option option2 = this.SubPath().unapplySeq((CharSequence)string2);
            if (!option2.isEmpty() && (list2 = (List)option2.get()).lengthCompare(2) == 0) {
                String string10 = (String)list2.apply(0);
                String string11 = (String)list2.apply(1);
                String prefix = string10;
                String config = string11;
                Either<String, SourceLink> either = this.parse(config, revision);
                if (either instanceof Left) {
                    Left l = (Left)either;
                    right = l;
                    return right;
                }
                if (!(either instanceof Right)) throw new MatchError(either);
                SourceLink sourceLink = (SourceLink)((Right)either).value();
                if (sourceLink instanceof PrefixedSourceLink) {
                    right = package$.MODULE$.Left().apply((Object)("Source path " + string + " has duplicated subpath setting (scm template can not contains '=')"));
                    return right;
                }
                SourceLink nested = sourceLink;
                right = package$.MODULE$.Right().apply((Object)PrefixedSourceLink$.MODULE$.apply(Paths.get(prefix, new String[0]), nested));
                return right;
            }
            Option option3 = this.BrokenKnownProvider().unapplySeq((CharSequence)string2);
            if (!option3.isEmpty() && (list = (List)option3.get()).lengthCompare(1) == 0 && ("gitlab".equals(string3 = (String)list.apply(0)) || "github".equals(string3))) {
                right = package$.MODULE$.Left().apply((Object)"Does not match known provider syntax: `<name>://organization/repository`");
                return right;
            }
        }
        String scaladocSetting = string2;
        if (!this.ScalaDocPatten().findFirstIn((CharSequence)scaladocSetting).nonEmpty()) {
            String other = string2;
            right = package$.MODULE$.Right().apply((Object)TemplateSourceLink$.MODULE$.apply(""));
            return right;
        }
        Regex.MatchIterator all = this.ScalaDocPatten().findAllIn((CharSequence)scaladocSetting);
        Tuple2 tuple2 = all.partition((Function1 & Serializable)key -> this.SupportedScalaDocPatternReplacements().contains(key));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Iterator supported = (Iterator)tuple2._1();
        Iterator unsupported = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)supported, (Object)unsupported);
        Iterator supported2 = (Iterator)tuple22._1();
        Iterator unsupported2 = (Iterator)tuple22._2();
        if (unsupported2.nonEmpty()) {
            right = package$.MODULE$.Left().apply((Object)("Unsupported patterns from scaladoc format are used: " + unsupported2.mkString(" ")));
            return right;
        }
        right = package$.MODULE$.Right().apply((Object)TemplateSourceLink$.MODULE$.apply((String)supported2.foldLeft((Object)string, (Function2 & Serializable)(template, pattern) -> template.replace((CharSequence)pattern, (CharSequence)this.SupportedScalaDocPatternReplacements().apply(pattern)))));
        return right;
    }

    private final String $anonfun$1() {
        return "";
    }

    private final Option $anonfun$4(Option revision$1) {
        return revision$1;
    }

    private final Left withRevision$2$$anonfun$1() {
        return package$.MODULE$.Left().apply((Object)"No revision provided");
    }

    private final Either withRevision$1(Option pathRev$1, Function1 template) {
        return (Either)pathRev$1.fold(this::withRevision$2$$anonfun$1, (Function1 & Serializable)r -> package$.MODULE$.Right().apply(template.apply(r)));
    }
}

