/*
 * Decompiled with CFR 0.152.
 */
package dotty.dokka.tasty.comments;

import java.io.Serializable;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Regexes$
implements Serializable {
    private static final Regex TrailingWhitespace;
    private static final Regex CleanCommentLine;
    private static final Regex DangerousTags;
    private static final Regex JavadocTags;
    private static final Regex SafeTags;
    private static final char safeTagMarker;
    private static final char endOfLine;
    private static final char endOfText;
    private static final Regex SingleTagRegex;
    private static final Regex SimpleTagRegex;
    private static final Regex SymbolTagRegex;
    private static final Regex CodeBlockStartRegex;
    private static final Regex CodeBlockEndRegex;
    public static final Regexes$ MODULE$;

    private Regexes$() {
    }

    static {
        MODULE$ = new Regexes$();
        TrailingWhitespace = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s+$"));
        CleanCommentLine = new Regex("(?:\\s*\\*\\s?\\s?)?(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        DangerousTags = new Regex("<(/?(div|ol|ul|li|h[1-6]|p))( [^>]*)?/?>|<!--.*-->", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        JavadocTags = new Regex("\\{\\@(code|docRoot|linkplain|link|literal|value)\\p{Zs}*([^}]*)\\}", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        SafeTags = new Regex("((&\\w+;)|(&#\\d+;)|(</?(abbr|acronym|address|area|a|bdo|big|blockquote|br|button|b|caption|cite|code|col|colgroup|dd|del|dfn|em|fieldset|form|hr|img|input|ins|i|kbd|label|legend|link|map|object|optgroup|option|param|pre|q|samp|select|small|span|strong|sub|sup|table|tbody|td|textarea|tfoot|th|thead|tr|tt|var)( [^>]*)?/?>))", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        safeTagMarker = (char)14;
        endOfLine = (char)10;
        endOfText = (char)3;
        SingleTagRegex = new Regex("\\s*@(\\S+)\\s*", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        SimpleTagRegex = new Regex("\\s*@(\\S+)\\s+(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        SymbolTagRegex = new Regex("\\s*@(param|tparam|throws|groupdesc|groupname|groupprio)\\s+(\\S*)\\s*(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        CodeBlockStartRegex = new Regex("(.*?)((?:\\{\\{\\{)|(?:\\u000E<pre(?: [^>]*)?>\\u000E))(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        CodeBlockEndRegex = new Regex("(.*?)((?:\\}\\}\\})|(?:\\u000E</pre>\\u000E))(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Regexes$.class);
    }

    public Regex TrailingWhitespace() {
        return TrailingWhitespace;
    }

    public Regex CleanCommentLine() {
        return CleanCommentLine;
    }

    public Regex DangerousTags() {
        return DangerousTags;
    }

    public Regex JavadocTags() {
        return JavadocTags;
    }

    public String javadocReplacement(Regex.Match mtch) {
        String string = mtch.group(1);
        return "code".equals(string) ? "<code>" + mtch.group(2) + "</code>" : ("docRoot".equals(string) ? "" : ("link".equals(string) ? "`[[" + mtch.group(2) + "]]`" : ("linkplain".equals(string) ? "[[" + mtch.group(2) + "]]" : ("literal".equals(string) ? "`" + mtch.group(2) + "`" : ("value".equals(string) ? "`" + mtch.group(2) + "`" : "")))));
    }

    public String htmlReplacement(Regex.Match mtch) {
        String string = mtch.group(1);
        return "p".equals(string) || "div".equals(string) ? "\n\n" : ("h1".equals(string) ? "\n= " : ("/h1".equals(string) ? " =\n" : ("h2".equals(string) ? "\n== " : ("/h2".equals(string) ? " ==\n" : ("h3".equals(string) ? "\n=== " : ("/h3".equals(string) ? " ===\n" : ("h4".equals(string) || "h5".equals(string) || "h6".equals(string) ? "\n==== " : ("/h4".equals(string) || "/h5".equals(string) || "/h6".equals(string) ? " ====\n" : ("li".equals(string) ? "\n *  - " : "")))))))));
    }

    public Regex SafeTags() {
        return SafeTags;
    }

    public char safeTagMarker() {
        return safeTagMarker;
    }

    public char endOfLine() {
        return endOfLine;
    }

    public char endOfText() {
        return endOfText;
    }

    public Regex SingleTagRegex() {
        return SingleTagRegex;
    }

    public Regex SimpleTagRegex() {
        return SimpleTagRegex;
    }

    public Regex SymbolTagRegex() {
        return SymbolTagRegex;
    }

    public Regex CodeBlockStartRegex() {
        return CodeBlockStartRegex;
    }

    public Regex CodeBlockEndRegex() {
        return CodeBlockEndRegex;
    }
}

