/*
 * Decompiled with CFR 0.152.
 */
package dotty.dokka;

import dotty.dokka.SourceLink;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import liqp.Template;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.deriving;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class SourceLink$
implements deriving.Mirror$.Product,
Serializable {
    private static final Regex SubPath;
    private static final Regex KnownProvider;
    private static final Regex BrokenKnownProvider;
    private static final Regex ScalaDocPatten;
    private static final Map SupportedScalaDocPatternReplacements;
    public static final SourceLink$ MODULE$;

    private SourceLink$() {
    }

    static {
        MODULE$ = new SourceLink$();
        SubPath = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^=]+)=(.+)"));
        KnownProvider = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\w+):\\/\\/([^\\/]+)\\/([^\\/]+)"));
        BrokenKnownProvider = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\w+):\\/\\/.+"));
        ScalaDocPatten = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\u20ac\\{(TPL_NAME|TPL_NAME|FILE_PATH|FILE_EXT|FILE_LINE|FILE_PATH_EXT)\\}"));
        Object[] objectArray = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_PATH_EXT}");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)"{{ path }}");
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_LINE}");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)"{{ line }}");
        SupportedScalaDocPatternReplacements = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceLink$.class);
    }

    public SourceLink apply(Option<Path> path, Template urlTemplate) {
        return new SourceLink(path, urlTemplate);
    }

    public SourceLink unapply(SourceLink x$1) {
        return x$1;
    }

    public String toString() {
        return "SourceLink";
    }

    public Regex SubPath() {
        return SubPath;
    }

    public Regex KnownProvider() {
        return KnownProvider;
    }

    public Regex BrokenKnownProvider() {
        return BrokenKnownProvider;
    }

    public Regex ScalaDocPatten() {
        return ScalaDocPatten;
    }

    public Map<String, String> SupportedScalaDocPatternReplacements() {
        return SupportedScalaDocPatternReplacements;
    }

    public String githubTemplate(String organization, String repo, String revision) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("https://github.com/" + organization + "/" + repo + "/{{ operation | replace: \"view\", \"blob\" }}/" + revision + "/{{ path }}#L{{ line }}"));
    }

    public String gitlabTemplate(String organization, String repo, String revision) {
        return "https://gitlab.com/" + organization + "/" + repo + "/-/{{ operation | replace: \"view\", \"blob\" }}/" + revision + "/{{ path }}#L{{ line }}";
    }

    private Option<SourceLink> parseLinkDefinition(String s) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Either<String, SourceLink> parse(String string, Option<String> revision2) {
        Either either;
        String string2 = string;
        if (string2 != null) {
            String string3;
            List list;
            List list2;
            List list3;
            Option option = this.KnownProvider().unapplySeq((CharSequence)string2);
            if (!option.isEmpty() && (list3 = (List)option.get()).lengthCompare(3) == 0) {
                String string4 = (String)list3.apply(0);
                String string5 = (String)list3.apply(1);
                String string6 = (String)list3.apply(2);
                String name = string4;
                String organization = string5;
                String repo = string6;
                String string7 = name;
                if ("github".equals(string7)) {
                    either = this.withRevision$1(revision2, (Function1)(JFunction1 & Serializable)revision -> this.githubTemplate(organization, repo, (String)revision));
                    return either;
                }
                if ("gitlab".equals(string7)) {
                    either = this.withRevision$1(revision2, (Function1)(JFunction1 & Serializable)revision -> this.gitlabTemplate(organization, repo, (String)revision));
                    return either;
                }
                String other = string7;
                either = package$.MODULE$.Left().apply((Object)("'" + other + "' is not a known provider, please provide full source path template."));
                return either;
            }
            Option option2 = this.SubPath().unapplySeq((CharSequence)string2);
            if (!option2.isEmpty() && (list2 = (List)option2.get()).lengthCompare(2) == 0) {
                String string8 = (String)list2.apply(0);
                String string9 = (String)list2.apply(1);
                String prefix = string8;
                String config = string9;
                Either<String, SourceLink> either2 = this.parse(config, revision2);
                if (either2 instanceof Left) {
                    Left l = (Left)either2;
                    either = l;
                    return either;
                }
                if (!(either2 instanceof Right)) throw new MatchError(either2);
                SourceLink sourceLink = (SourceLink)((Right)either2).value();
                if (sourceLink == null) throw new MatchError(either2);
                SourceLink sourceLink2 = this.unapply(sourceLink);
                Option<Path> option3 = sourceLink2._1();
                Template template2 = sourceLink2._2();
                if (option3 instanceof Some) {
                    Path prefix2 = (Path)((Some)option3).value();
                    either = package$.MODULE$.Left().apply((Object)("Source path " + string + " has duplicated subpath setting (scm template can not contains '=')"));
                    return either;
                }
                if (!None$.MODULE$.equals(option3)) throw new MatchError(either2);
                Template template3 = template2;
                either = package$.MODULE$.Right().apply((Object)this.apply((Option<Path>)Some$.MODULE$.apply((Object)Paths.get(prefix, new String[0])), template3));
                return either;
            }
            Option option4 = this.BrokenKnownProvider().unapplySeq((CharSequence)string2);
            if (!option4.isEmpty() && (list = (List)option4.get()).lengthCompare(1) == 0 && ("gitlab".equals(string3 = (String)list.apply(0)) || "github".equals(string3))) {
                either = package$.MODULE$.Left().apply((Object)"Does not match known provider syntax: `<name>://organization/repository`");
                return either;
            }
        }
        String scaladocSetting = string2;
        if (!this.ScalaDocPatten().findFirstIn((CharSequence)scaladocSetting).nonEmpty()) {
            String template4 = string2;
            either = this.asTemplate$1(template4);
            return either;
        }
        Regex.MatchIterator all = this.ScalaDocPatten().findAllIn((CharSequence)scaladocSetting);
        Tuple2 tuple2 = all.partition((Function1)(JFunction1 & Serializable)key -> this.SupportedScalaDocPatternReplacements().contains(key));
        if (!(tuple2 instanceof Tuple2)) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = tuple2;
        Iterator supported = (Iterator)tuple22._1();
        Iterator unsupported = (Iterator)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)supported, (Object)unsupported);
        Iterator supported2 = (Iterator)tuple23._1();
        Iterator unsupported2 = (Iterator)tuple23._2();
        if (unsupported2.nonEmpty()) {
            either = package$.MODULE$.Left().apply((Object)("Unsupported patterns from scaladoc format are used: " + unsupported2.mkString(" ")));
            return either;
        }
        either = this.asTemplate$1((String)supported2.foldLeft((Object)string, (Function2)(JFunction2 & Serializable)(template, pattern) -> template.replace((CharSequence)pattern, (CharSequence)this.SupportedScalaDocPatternReplacements().apply(pattern))));
        return either;
    }

    public SourceLink fromProduct(Product x$0) {
        return new SourceLink((Option<Path>)((Option)x$0.productElement(0)), (Template)x$0.productElement(1));
    }

    private final Either asTemplate$1(String template) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)this.apply((Option<Path>)None$.MODULE$, Template.parse((String)template)));
        }
        catch (RuntimeException e) {
            right = package$.MODULE$.Left().apply((Object)("Failed to parse template: " + e.getMessage()));
        }
        return right;
    }

    private final Left withRevision$2$$anonfun$1() {
        return package$.MODULE$.Left().apply((Object)"No revision provided");
    }

    private final Either withRevision$1(Option revision$1, Function1 template) {
        return (Either)revision$1.fold(this::withRevision$2$$anonfun$1, (Function1)(JFunction1 & Serializable)rev -> package$.MODULE$.Right().apply((Object)this.apply((Option<Path>)None$.MODULE$, Template.parse((String)((String)template.apply(rev))))));
    }
}

