/*
 * Decompiled with CFR 0.152.
 */
package dotty.dokka;

import dotty.dokka.HTML$;
import dotty.dokka.SignatureRenderer;
import dotty.dokka.model.api.HierarchyDiagram;
import dotty.dokka.model.api.Kind;
import dotty.dokka.model.api.Kind$;
import dotty.dokka.model.api.Vertex;
import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public final class DotDiagramBuilder$
implements Serializable {
    public static final DotDiagramBuilder$ MODULE$ = new DotDiagramBuilder$();

    private DotDiagramBuilder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DotDiagramBuilder$.class);
    }

    public String build(HierarchyDiagram diagram, SignatureRenderer renderer) {
        String vertecies = ((IterableOnceOps)((IterableOps)((SeqOps)diagram.edges().flatMap((Function1)(JFunction1 & Serializable)edge -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vertex[]{edge.from(), edge.to()})))).distinct()).map((Function1)(JFunction1 & Serializable)vertex -> "node" + vertex.id() + " [label=\"" + this.getHtmlLabel((Vertex)vertex, renderer) + "\", style=\"" + this.getStyle((Vertex)vertex) + "\"];\n")).mkString();
        String edges = ((IterableOnceOps)diagram.edges().map((Function1)(JFunction1 & Serializable)edge -> "node" + edge.from().id() + " -> node" + edge.to().id() + ";\n")).mkString();
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" digraph g {\n        | " + vertecies + "\n        |\n        | " + edges + "\n        |}\n        |"));
    }

    private String getStyle(Vertex vertex) {
        String string;
        Kind kind = vertex.body().kind();
        Kind kind2 = Kind$.Class;
        Kind kind3 = kind;
        if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
            string = "fill: #45AD7D;";
        } else {
            Kind kind4 = Kind$.Object;
            Kind kind5 = kind;
            if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
                string = "fill: #285577;";
            } else {
                Kind kind6 = Kind$.Trait;
                Kind kind7 = kind;
                if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
                    string = "fill: #1CAACF;";
                } else {
                    Kind kind8 = Kind$.Enum;
                    Kind kind9 = kind;
                    if (!(kind8 != null ? !kind8.equals(kind9) : kind9 != null)) {
                        string = "fill: #B66722;";
                    } else {
                        Kind kind10 = Kind$.EnumCase;
                        Kind kind11 = kind;
                        if (!(kind10 != null ? !kind10.equals(kind11) : kind11 != null)) {
                            string = "fill: #B66722;";
                        } else {
                            Kind other = kind;
                            throw package$.MODULE$.error("unexpected value: " + other);
                        }
                    }
                }
            }
        }
        return string;
    }

    private String getHtmlLabel(Vertex vertex, SignatureRenderer renderer) {
        return HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.style().$colon$eq("color: #FFFFFF;")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{vertex.body().kind().name(), " ", HTML$.MODULE$.span().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.style().$colon$eq("text-decoration: underline;")}), (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{vertex.body().signature().map((Function1)(JFunction1 & Serializable)_$1 -> renderer.renderElementWith((Serializable)_$1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HTML$.MODULE$.style().$colon$eq("color: #FFFFFF;")})))}))})).toString().replace("\"", "\\\"");
    }
}

