/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.AbstractReporter;
import dotty.tools.dotc.reporting.CodeAction;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.xsbt.PositionBridge;
import dotty.tools.xsbt.Problem;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.javaapi.CollectionConverters;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.Severity;

public final class DelegatingReporter
extends AbstractReporter {
    private Reporter delegate;
    private final Function<SourceFile, String> lookupVirtualFileId;

    public DelegatingReporter(Reporter reporter, Function<SourceFile, String> function) {
        this.delegate = reporter;
        this.lookupVirtualFileId = function;
    }

    public void dropDelegate() {
        this.delegate = null;
    }

    public void printSummary(Contexts.Context context) {
        this.delegate.printSummary();
    }

    public void doReport(Diagnostic diagnostic, Contexts.Context context) {
        Severity severity = DelegatingReporter.severityOf(diagnostic.level());
        Position position = this.positionOf(diagnostic.pos().nonInlined());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.messageAndPos(diagnostic, context));
        Message message = diagnostic.msg();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(message.message());
        String string = String.valueOf(message.errorId().errorNumber());
        boolean bl = Diagnostic.shouldExplain((Diagnostic)diagnostic, (Contexts.Context)context);
        List list = CollectionConverters.asJava((Seq)message.actions(context));
        if (bl && !message.explanation().isEmpty()) {
            stringBuilder.append(this.explanation(message, context));
            stringBuilder2.append(System.lineSeparator()).append(this.explanation(message, context));
        }
        this.delegate.log((xsbti.Problem)new Problem(position, stringBuilder2.toString(), severity, stringBuilder.toString(), string, list, this.lookupVirtualFileId));
    }

    public void reportBasicWarning(String string) {
        Position position = PositionBridge.noPosition;
        Severity severity = Severity.Warn;
        String string2 = "-1";
        List<CodeAction> list = Collections.emptyList();
        this.delegate.log((xsbti.Problem)new Problem(position, string, severity, string, string2, list, this.lookupVirtualFileId));
    }

    private static Severity severityOf(int n) {
        Severity severity;
        switch (n) {
            case 2: {
                severity = Severity.Error;
                break;
            }
            case 1: {
                severity = Severity.Warn;
                break;
            }
            case 0: {
                severity = Severity.Info;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Bad diagnostic level: %s", n));
            }
        }
        return severity;
    }

    private Position positionOf(SourcePosition sourcePosition) {
        if (sourcePosition.exists()) {
            return new PositionBridge(sourcePosition, this.lookupVirtualFileId.apply(sourcePosition.source()));
        }
        return PositionBridge.noPosition;
    }

    public HashMap<Tuple2<SourceFile, Integer>, Diagnostic> dotty$tools$dotc$reporting$UniqueMessagePositions$$positions() {
        return super.dotty$tools$dotc$reporting$UniqueMessagePositions$$positions();
    }
}

