/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.ScalacCommand;
import dotty.tools.dotc.config.Properties;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.io.AbstractFile;
import dotty.tools.xsbt.DelegatingReporter;
import dotty.tools.xsbt.InterfaceCompileFailed;
import dotty.tools.xsbt.ZincPlainFile;
import dotty.tools.xsbt.ZincVirtualFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import scala.collection.mutable.ListBuffer;
import xsbti.AnalysisCallback;
import xsbti.Logger;
import xsbti.PathBasedFile;
import xsbti.Problem;
import xsbti.Reporter;
import xsbti.VirtualFile;
import xsbti.compile.Output;

public class CompilerBridgeDriver
extends Driver {
    private final String[] scalacOptions;
    private final String[] args;
    private static final String StopInfoError = "Compiler option supplied that disabled Zinc compilation.";

    public CompilerBridgeDriver(String[] stringArray, Output output) {
        this.scalacOptions = stringArray;
        if (!output.getSingleOutputAsPath().isPresent()) {
            throw new IllegalArgumentException("output should be a SingleOutput, was a " + output.getClass().getName());
        }
        this.args = new String[stringArray.length + 2];
        System.arraycopy(stringArray, 0, this.args, 0, stringArray.length);
        this.args[stringArray.length] = "-d";
        this.args[stringArray.length + 1] = ((Path)output.getSingleOutputAsPath().get()).toAbsolutePath().toString();
    }

    public boolean sourcesRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run(VirtualFile[] virtualFileArray, AnalysisCallback analysisCallback, Logger logger, Reporter reporter) {
        DelegatingReporter delegatingReporter = new DelegatingReporter(reporter);
        try {
            logger.debug(this::infoOnCachedCompiler);
            Contexts.FreshContext freshContext = this.initCtx().fresh().setReporter((dotty.tools.dotc.reporting.Reporter)delegatingReporter).setSbtCallback(analysisCallback);
            Contexts.Context context = (Contexts.Context)this.setup(this.args, (Contexts.Context)freshContext).map(tuple2 -> (Contexts.Context)tuple2._2).getOrElse(() -> CompilerBridgeDriver.lambda$run$1((Contexts.Context)freshContext));
            if (ScalacCommand.isHelpFlag((ScalaSettings)context.settings(), (Settings.SettingsState)context.settingsState())) {
                throw new InterfaceCompileFailed(this.args, new Problem[0], StopInfoError);
            }
            if (!reporter.hasErrors()) {
                logger.debug(this::prettyPrintCompilationArguments);
                Compiler compiler = this.newCompiler(context);
                VirtualFile[] virtualFileArray2 = new VirtualFile[virtualFileArray.length];
                System.arraycopy(virtualFileArray, 0, virtualFileArray2, 0, virtualFileArray.length);
                Arrays.sort(virtualFileArray2, new Comparator<VirtualFile>(){

                    @Override
                    public int compare(VirtualFile virtualFile, VirtualFile virtualFile2) {
                        return virtualFile.id().compareTo(virtualFile2.id());
                    }
                });
                ListBuffer listBuffer = new ListBuffer();
                for (VirtualFile virtualFile : virtualFileArray2) {
                    listBuffer.append((Object)CompilerBridgeDriver.asDottyFile(virtualFile));
                }
                this.doCompile(compiler, listBuffer.toList(), context);
                for (VirtualFile virtualFile : reporter.problems()) {
                    analysisCallback.problem(virtualFile.category(), virtualFile.position(), virtualFile.message(), virtualFile.severity(), true);
                }
            }
            reporter.printSummary();
            if (reporter.hasErrors()) {
                logger.debug(() -> "Compilation failed");
                throw new InterfaceCompileFailed(this.args, reporter.problems(), "Compilation failed");
            }
        }
        finally {
            delegatingReporter.dropDelegate();
        }
    }

    private static AbstractFile asDottyFile(VirtualFile virtualFile) {
        if (virtualFile instanceof PathBasedFile) {
            return new ZincPlainFile((PathBasedFile)virtualFile);
        }
        try {
            return new ZincVirtualFile(virtualFile);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid file " + virtualFile.name(), iOException);
        }
    }

    private String infoOnCachedCompiler() {
        String string = Integer.toHexString(((Object)((Object)this)).hashCode());
        String string2 = Properties.versionString();
        return String.format("[zinc] Running cached compiler %s for Scala Compiler %s", string, string2);
    }

    private String prettyPrintCompilationArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[zinc] The Scala compiler is invoked with:");
        for (String string : this.scalacOptions) {
            stringBuilder.append("\n\t");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ Contexts.Context lambda$run$1(Contexts.Context context) {
        return context;
    }
}

