/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.reporting.AbstractReporter;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.xsbt.PositionBridge;
import dotty.tools.xsbt.Problem;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.Severity;

public final class DelegatingReporter
extends AbstractReporter {
    private Reporter delegate;

    public DelegatingReporter(Reporter reporter) {
        this.delegate = reporter;
    }

    public void dropDelegate() {
        this.delegate = null;
    }

    public void printSummary(Contexts.Context context) {
        this.delegate.printSummary();
    }

    public void doReport(Diagnostic diagnostic, Contexts.Context context) {
        Severity severity = DelegatingReporter.severityOf(diagnostic.level());
        Position position = DelegatingReporter.positionOf(diagnostic.pos().nonInlined());
        Message message = diagnostic.msg();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.messageAndPos(message, diagnostic.pos(), this.diagnosticLevel(diagnostic), context));
        boolean bl = Diagnostic.shouldExplain((Diagnostic)diagnostic, (Contexts.Context)context);
        if (bl && !message.explanation().isEmpty()) {
            stringBuilder.append(this.explanation(message, context));
        }
        this.delegate.log((xsbti.Problem)new Problem(position, message.msg(), severity, stringBuilder.toString()));
    }

    private static Severity severityOf(int n) {
        Severity severity;
        switch (n) {
            case 2: {
                severity = Severity.Error;
                break;
            }
            case 1: {
                severity = Severity.Warn;
                break;
            }
            case 0: {
                severity = Severity.Info;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Bad diagnostic level: %s", n));
            }
        }
        return severity;
    }

    private static Position positionOf(SourcePosition sourcePosition) {
        if (sourcePosition.exists()) {
            return new PositionBridge(sourcePosition, sourcePosition.source());
        }
        return PositionBridge.noPosition;
    }
}

