/*
 * Decompiled with CFR 0.152.
 */
package xsbt;

import dotty.tools.dotc.Main;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import xsbt.CachedCompilerImpl;
import xsbt.CompilerClassLoader;
import xsbti.AnalysisCallback;
import xsbti.Logger;
import xsbti.Reporter;
import xsbti.compile.CachedCompiler;
import xsbti.compile.CompileProgress;
import xsbti.compile.DependencyChanges;
import xsbti.compile.Output;

public final class CompilerInterface {
    public CachedCompiler newCompiler(String[] stringArray, Output output, Logger logger, Reporter reporter) throws Exception {
        if (this.isClassLoaderValid()) {
            return new CachedCompilerImpl(stringArray, output);
        }
        logger.warn(() -> "The compiler class loader is badly configured.\nConsider using a more recent version of your build tool:\n - sbt >= 1.4.0 and sbt-dotty >= 1.5.0\n - Mill >= 0.9.3-21-002361\n - Bloop >= 1.4.6-23-20a501bc");
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ClassLoader classLoader2 = CompilerClassLoader.fixBridgeLoader(classLoader);
            Class<?> clazz = classLoader2.loadClass("xsbt.CachedCompilerImpl");
            return (CachedCompiler)clazz.getConstructors()[0].newInstance(stringArray, output);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private boolean isClassLoaderValid() {
        ClassLoader classLoader = Main.class.getClassLoader();
        Class<Logger> clazz = Logger.class;
        try {
            return classLoader.loadClass("xsbti.Logger") == clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public void run(File[] fileArray, DependencyChanges dependencyChanges, AnalysisCallback analysisCallback, Logger logger, Reporter reporter, CompileProgress compileProgress, CachedCompiler cachedCompiler) {
        cachedCompiler.run(fileArray, dependencyChanges, analysisCallback, logger, reporter, compileProgress);
    }
}

