/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import scala.Char$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.meta.internal.metals.Classfile;
import scala.meta.internal.metals.Fuzzy$;

public class ClassfileComparator
implements Comparator<Classfile> {
    private final String query;

    public ClassfileComparator(String query) {
        this.query = query;
    }

    @Override
    public Comparator<Classfile> reversed() {
        return Comparator.super.reversed();
    }

    @Override
    public Comparator<Classfile> thenComparing(Comparator<? super Classfile> x$0) {
        return Comparator.super.thenComparing(x$0);
    }

    @Override
    public <U> Comparator<Classfile> thenComparing(Function<? super Classfile, ? extends U> x$0, Comparator<? super U> x$1) {
        return Comparator.super.thenComparing(x$0, x$1);
    }

    @Override
    public <U extends Comparable<? super U>> Comparator<Classfile> thenComparing(Function<? super Classfile, ? extends U> x$0) {
        return Comparator.super.thenComparing(x$0);
    }

    @Override
    public Comparator<Classfile> thenComparingInt(ToIntFunction<? super Classfile> x$0) {
        return Comparator.super.thenComparingInt(x$0);
    }

    @Override
    public Comparator<Classfile> thenComparingLong(ToLongFunction<? super Classfile> x$0) {
        return Comparator.super.thenComparingLong(x$0);
    }

    @Override
    public Comparator<Classfile> thenComparingDouble(ToDoubleFunction<? super Classfile> x$0) {
        return Comparator.super.thenComparingDouble(x$0);
    }

    public int characterCount(String string, char ch) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int compare(Classfile o1, Classfile o2) {
        int byNameLength = Integer.compare(Fuzzy$.MODULE$.nameLength(o1.filename()), Fuzzy$.MODULE$.nameLength(o2.filename()));
        if (byNameLength != 0) {
            return byNameLength;
        }
        int byInnerclassDepth = Integer.compare(this.characterCount(o1.filename(), '$'), this.characterCount(o2.filename(), '$'));
        if (byInnerclassDepth != 0) {
            return byInnerclassDepth;
        }
        int byFirstQueryCharacter = Integer.compare(o1.filename().indexOf(Char$.MODULE$.char2int(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(this.query)))), o2.filename().indexOf(Char$.MODULE$.char2int(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(this.query)))));
        if (byFirstQueryCharacter != 0) {
            return byFirstQueryCharacter;
        }
        int byPackageDepth = Integer.compare(this.characterCount(o1.pkg(), '/'), this.characterCount(o2.pkg(), '/'));
        if (byPackageDepth != 0) {
            return byPackageDepth;
        }
        return o1.filename().compareTo(o2.filename());
    }
}

