/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.meta.internal.metals.Classfile;
import scala.meta.internal.metals.CompressedPackageIndex$;
import scala.meta.internal.metals.Compression$;
import scala.meta.internal.metals.PackageIndex;
import scala.meta.internal.metals.StringBloomFilter;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class CompressedPackageIndex
implements Product,
Serializable {
    private final String[] packages;
    private final StringBloomFilter bloom;
    private final byte[] memberBytes;

    public static int DefaultBucketSize() {
        return CompressedPackageIndex$.MODULE$.DefaultBucketSize();
    }

    public static CompressedPackageIndex apply(String[] stringArray, StringBloomFilter stringBloomFilter, byte[] byArray) {
        return CompressedPackageIndex$.MODULE$.apply(stringArray, stringBloomFilter, byArray);
    }

    public static CompressedPackageIndex[] fromPackages(PackageIndex packageIndex, Function1<String, Object> function1, int n) {
        return CompressedPackageIndex$.MODULE$.fromPackages(packageIndex, function1, n);
    }

    public static CompressedPackageIndex fromProduct(Product product) {
        return CompressedPackageIndex$.MODULE$.fromProduct(product);
    }

    public static CompressedPackageIndex unapply(CompressedPackageIndex compressedPackageIndex) {
        return CompressedPackageIndex$.MODULE$.unapply(compressedPackageIndex);
    }

    public static int fromPackages$default$3() {
        return CompressedPackageIndex$.MODULE$.fromPackages$default$3();
    }

    public CompressedPackageIndex(String[] packages, StringBloomFilter bloom, byte[] memberBytes) {
        this.packages = packages;
        this.bloom = bloom;
        this.memberBytes = memberBytes;
        Object object = Predef$.MODULE$.refArrayOps((Object[])packages);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(object));
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1246836997, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        CompressedPackageIndex compressedPackageIndex;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CompressedPackageIndex)) return false;
        CompressedPackageIndex compressedPackageIndex2 = compressedPackageIndex = (CompressedPackageIndex)object;
        if (this.packages() != compressedPackageIndex2.packages()) return false;
        StringBloomFilter stringBloomFilter = this.bloom();
        StringBloomFilter stringBloomFilter2 = compressedPackageIndex2.bloom();
        if (stringBloomFilter == null) {
            if (stringBloomFilter2 != null) {
                return false;
            }
        } else if (!stringBloomFilter.equals(stringBloomFilter2)) return false;
        if (this.memberBytes() != compressedPackageIndex2.memberBytes()) return false;
        if (!compressedPackageIndex2.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CompressedPackageIndex;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "CompressedPackageIndex";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "packages";
            }
            case 1: {
                return "bloom";
            }
            case 2: {
                return "memberBytes";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String[] packages() {
        return this.packages;
    }

    public StringBloomFilter bloom() {
        return this.bloom;
    }

    public byte[] memberBytes() {
        return this.memberBytes;
    }

    public Classfile[] members() {
        return Compression$.MODULE$.decompress(this.memberBytes());
    }

    public int compare(CompressedPackageIndex other) {
        return StringOps$.MODULE$.compare$extension(Predef$.MODULE$.augmentString(this.packages()[0]), other.packages()[0]);
    }

    public CompressedPackageIndex copy(String[] packages, StringBloomFilter bloom, byte[] memberBytes) {
        return new CompressedPackageIndex(packages, bloom, memberBytes);
    }

    public String[] copy$default$1() {
        return this.packages();
    }

    public StringBloomFilter copy$default$2() {
        return this.bloom();
    }

    public byte[] copy$default$3() {
        return this.memberBytes();
    }

    public String[] _1() {
        return this.packages();
    }

    public StringBloomFilter _2() {
        return this.bloom();
    }

    public byte[] _3() {
        return this.memberBytes();
    }
}

