/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.meta.internal.metals.Fuzzy$;
import scala.meta.internal.metals.StringBloomFilter;
import scala.meta.internal.metals.WorkspaceSymbolQuery$;
import scala.meta.internal.metals.WorkspaceSymbolQuery$AlternativeQuery$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;

public class WorkspaceSymbolQuery
implements Product,
Serializable {
    private final String query;
    private final AlternativeQuery[] alternatives;
    private final boolean isTrailingDot;
    private final boolean isClasspath;
    private final boolean isShortQueryRetry;
    private final boolean isShortQuery;

    public static WorkspaceSymbolQuery apply(String string, AlternativeQuery[] alternativeQueryArray, boolean bl, boolean bl2, boolean bl3) {
        return WorkspaceSymbolQuery$.MODULE$.apply(string, alternativeQueryArray, bl, bl2, bl3);
    }

    public static WorkspaceSymbolQuery exact(String string, boolean bl) {
        return WorkspaceSymbolQuery$.MODULE$.exact(string, bl);
    }

    public static WorkspaceSymbolQuery fromProduct(Product product) {
        return WorkspaceSymbolQuery$.MODULE$.fromProduct(product);
    }

    public static WorkspaceSymbolQuery fromTextQuery(String string) {
        return WorkspaceSymbolQuery$.MODULE$.fromTextQuery(string);
    }

    public static WorkspaceSymbolQuery unapply(WorkspaceSymbolQuery workspaceSymbolQuery) {
        return WorkspaceSymbolQuery$.MODULE$.unapply(workspaceSymbolQuery);
    }

    public static boolean exact$default$2() {
        return WorkspaceSymbolQuery$.MODULE$.exact$default$2();
    }

    public static boolean $lessinit$greater$default$4() {
        return WorkspaceSymbolQuery$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return WorkspaceSymbolQuery$.MODULE$.$lessinit$greater$default$5();
    }

    public WorkspaceSymbolQuery(String query, AlternativeQuery[] alternatives, boolean isTrailingDot, boolean isClasspath, boolean isShortQueryRetry) {
        this.query = query;
        this.alternatives = alternatives;
        this.isTrailingDot = isTrailingDot;
        this.isClasspath = isClasspath;
        this.isShortQueryRetry = isShortQueryRetry;
        this.isShortQuery = query.length() < Fuzzy$.MODULE$.PrefixSearchLimit();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)-215670181);
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.query()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.alternatives()));
        n = Statics.mix((int)n, (int)(this.isTrailingDot() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.isClasspath() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.isShortQueryRetry() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        WorkspaceSymbolQuery workspaceSymbolQuery;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof WorkspaceSymbolQuery)) return false;
        WorkspaceSymbolQuery workspaceSymbolQuery2 = workspaceSymbolQuery = (WorkspaceSymbolQuery)object;
        if (this.isTrailingDot() != workspaceSymbolQuery2.isTrailingDot()) return false;
        if (this.isClasspath() != workspaceSymbolQuery2.isClasspath()) return false;
        if (this.isShortQueryRetry() != workspaceSymbolQuery2.isShortQueryRetry()) return false;
        String string = this.query();
        String string2 = workspaceSymbolQuery2.query();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.alternatives() != workspaceSymbolQuery2.alternatives()) return false;
        if (!workspaceSymbolQuery2.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof WorkspaceSymbolQuery;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "WorkspaceSymbolQuery";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this._3());
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this._4());
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "query";
            }
            case 1: {
                return "alternatives";
            }
            case 2: {
                return "isTrailingDot";
            }
            case 3: {
                return "isClasspath";
            }
            case 4: {
                return "isShortQueryRetry";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String query() {
        return this.query;
    }

    public AlternativeQuery[] alternatives() {
        return this.alternatives;
    }

    public boolean isTrailingDot() {
        return this.isTrailingDot;
    }

    public boolean isClasspath() {
        return this.isClasspath;
    }

    public boolean isShortQueryRetry() {
        return this.isShortQueryRetry;
    }

    public boolean isShortQuery() {
        return this.isShortQuery;
    }

    public boolean matches(StringBloomFilter bloom) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.alternatives());
        return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$1 -> _$1.matches(bloom));
    }

    public boolean matches(CharSequence symbol) {
        if (this.isShortQuery() && !this.isShortQueryRetry()) {
            return Fuzzy$.MODULE$.prefixMatch(this.query(), symbol, Fuzzy$.MODULE$.prefixMatch$default$3());
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.alternatives());
        return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$2 -> _$2.matches(symbol, this.isTrailingDot()));
    }

    public WorkspaceSymbolQuery copy(String query, AlternativeQuery[] alternatives, boolean isTrailingDot, boolean isClasspath, boolean isShortQueryRetry) {
        return new WorkspaceSymbolQuery(query, alternatives, isTrailingDot, isClasspath, isShortQueryRetry);
    }

    public String copy$default$1() {
        return this.query();
    }

    public AlternativeQuery[] copy$default$2() {
        return this.alternatives();
    }

    public boolean copy$default$3() {
        return this.isTrailingDot();
    }

    public boolean copy$default$4() {
        return this.isClasspath();
    }

    public boolean copy$default$5() {
        return this.isShortQueryRetry();
    }

    public String _1() {
        return this.query();
    }

    public AlternativeQuery[] _2() {
        return this.alternatives();
    }

    public boolean _3() {
        return this.isTrailingDot();
    }

    public boolean _4() {
        return this.isClasspath();
    }

    public boolean _5() {
        return this.isShortQueryRetry();
    }

    public static class AlternativeQuery
    implements Product,
    Serializable {
        private final String query;
        private final CharSequence[] bloomFilterQueries;
        private final long[] bloomFilterCachedQueries;

        public static AlternativeQuery[] all(String string) {
            return WorkspaceSymbolQuery$AlternativeQuery$.MODULE$.all(string);
        }

        public static AlternativeQuery apply(String string, boolean bl) {
            return WorkspaceSymbolQuery$AlternativeQuery$.MODULE$.apply(string, bl);
        }

        public static AlternativeQuery apply(String string, CharSequence[] charSequenceArray, long[] lArray) {
            return WorkspaceSymbolQuery$AlternativeQuery$.MODULE$.apply(string, charSequenceArray, lArray);
        }

        public static AlternativeQuery fromProduct(Product product) {
            return WorkspaceSymbolQuery$AlternativeQuery$.MODULE$.fromProduct(product);
        }

        public static AlternativeQuery unapply(AlternativeQuery alternativeQuery) {
            return WorkspaceSymbolQuery$AlternativeQuery$.MODULE$.unapply(alternativeQuery);
        }

        public static boolean apply$default$2() {
            return WorkspaceSymbolQuery$AlternativeQuery$.MODULE$.apply$default$2();
        }

        public AlternativeQuery(String query, CharSequence[] bloomFilterQueries, long[] bloomFilterCachedQueries) {
            this.query = query;
            this.bloomFilterQueries = bloomFilterQueries;
            this.bloomFilterCachedQueries = bloomFilterCachedQueries;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1156275133, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            AlternativeQuery alternativeQuery;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AlternativeQuery)) return false;
            AlternativeQuery alternativeQuery2 = alternativeQuery = (AlternativeQuery)object;
            String string = this.query();
            String string2 = alternativeQuery2.query();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.bloomFilterQueries() != alternativeQuery2.bloomFilterQueries()) return false;
            if (this.bloomFilterCachedQueries() != alternativeQuery2.bloomFilterCachedQueries()) return false;
            if (!alternativeQuery2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AlternativeQuery;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "AlternativeQuery";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "query";
                }
                case 1: {
                    return "bloomFilterQueries";
                }
                case 2: {
                    return "bloomFilterCachedQueries";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String query() {
            return this.query;
        }

        public CharSequence[] bloomFilterQueries() {
            return this.bloomFilterQueries;
        }

        public long[] bloomFilterCachedQueries() {
            return this.bloomFilterCachedQueries;
        }

        public boolean matches(StringBloomFilter bloom) {
            Object object = Predef$.MODULE$.longArrayOps(this.bloomFilterCachedQueries());
            return ArrayOps$.MODULE$.forall$extension(object, (Function1)((JFunction1.mcZJ.sp & Serializable)arg_0 -> WorkspaceSymbolQuery$.scala$meta$internal$metals$WorkspaceSymbolQuery$AlternativeQuery$$_$matches$$anonfun$3(bloom, arg_0)));
        }

        public boolean matches(CharSequence symbol, boolean isTrailingDot) {
            return Fuzzy$.MODULE$.matches(this.query(), symbol, isTrailingDot ? 1 : 0);
        }

        public AlternativeQuery copy(String query, CharSequence[] bloomFilterQueries, long[] bloomFilterCachedQueries) {
            return new AlternativeQuery(query, bloomFilterQueries, bloomFilterCachedQueries);
        }

        public String copy$default$1() {
            return this.query();
        }

        public CharSequence[] copy$default$2() {
            return this.bloomFilterQueries();
        }

        public long[] copy$default$3() {
            return this.bloomFilterCachedQueries();
        }

        public String _1() {
            return this.query();
        }

        public CharSequence[] _2() {
            return this.bloomFilterQueries();
        }

        public long[] _3() {
            return this.bloomFilterCachedQueries();
        }
    }
}

