/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.PriorityQueue;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.meta.internal.metals.Classfile;
import scala.meta.internal.metals.ClassfileComparator;
import scala.meta.internal.metals.ClasspathSearch$;
import scala.meta.internal.metals.ClasspathSearch$Indexer$;
import scala.meta.internal.metals.CompressedPackageIndex;
import scala.meta.internal.metals.CompressedPackageIndex$;
import scala.meta.internal.metals.ExcludedPackagesHandler;
import scala.meta.internal.metals.WorkspaceSymbolQuery;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.meta.pc.SymbolSearch;
import scala.meta.pc.SymbolSearchVisitor;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class ClasspathSearch {
    private final CompressedPackageIndex[] packages;
    private final int maxNonExactMatches;

    public static ClasspathSearch empty() {
        return ClasspathSearch$.MODULE$.empty();
    }

    public static ClasspathSearch fromClasspath(Seq<Path> seq, ExcludedPackagesHandler excludedPackagesHandler, int n) {
        return ClasspathSearch$.MODULE$.fromClasspath(seq, excludedPackagesHandler, n);
    }

    public static int fromClasspath$default$3() {
        return ClasspathSearch$.MODULE$.fromClasspath$default$3();
    }

    public ClasspathSearch(CompressedPackageIndex[] packages) {
        this.packages = packages;
        this.maxNonExactMatches = 10;
    }

    public CompressedPackageIndex[] packages() {
        return this.packages;
    }

    public Tuple2<SymbolSearch.Result, Object> search(WorkspaceSymbolQuery query, SymbolSearchVisitor visitor) {
        String string = query.query();
        String string2 = "_";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Tuple2$.MODULE$.apply((Object)SymbolSearch.Result.COMPLETE, (Object)BoxesRunTime.boxToInteger((int)0));
        }
        PriorityQueue<Classfile> classfiles = new PriorityQueue<Classfile>(new ClassfileComparator(query.query()));
        this.search(query, (Function1<String, Object>)(Function1 & Serializable)pkg -> visitor.shouldVisitPackage(pkg), (Function0<Object>)(Function0 & Serializable)() -> visitor.isCancelled()).foreach((Function1 & Serializable)classfile -> classfiles.add((Classfile)classfile));
        IntRef nonExactMatches = IntRef.create((int)0);
        IntRef exactMatches = IntRef.create((int)0);
        ObjectRef searchResult = ObjectRef.create((Object)(query.isShortQuery() ? SymbolSearch.Result.INCOMPLETE : SymbolSearch.Result.COMPLETE));
        CommonMtagsEnrichments$.MODULE$.XtensionJavaPriorityQueue(classfiles).pollingIterator().withFilter((Function1 & Serializable)hit -> {
            boolean isContinue;
            boolean bl = isContinue = !visitor.isCancelled() && (nonExactMatches$1.elem < this.maxNonExactMatches || hit.isExact(query));
            if (!isContinue) {
                searchResult$1.elem = SymbolSearch.Result.INCOMPLETE;
            }
            return isContinue;
        }).foreach((Function1)(JProcedure1 & Serializable)hit -> {
            int added = visitor.visitClassfile(hit.pkg(), hit.filename());
            if (added > 0) {
                if (!hit.isExact(query)) {
                    nonExactMatches$2.elem += added;
                    return;
                }
                exactMatches$1.elem += added;
                return;
            }
        });
        return Tuple2$.MODULE$.apply((Object)((SymbolSearch.Result)searchResult.elem), (Object)BoxesRunTime.boxToInteger((int)(nonExactMatches.elem + exactMatches.elem)));
    }

    private Iterator<Classfile> search(WorkspaceSymbolQuery query, Function1<String, Object> shouldVisitPackage, Function0<Object> isCancelled) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.packages());
        return ArrayOps$.MODULE$.iterator$extension(object).withFilter((Function1 & Serializable)pkg -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])pkg.packages());
            return ArrayOps$.MODULE$.exists$extension(object, shouldVisitPackage);
        }).withFilter((Function1 & Serializable)pkg -> !isCancelled.apply$mcZ$sp()).withFilter((Function1 & Serializable)pkg -> query.matches(pkg.bloom())).flatMap((Function1 & Serializable)pkg -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])pkg.members());
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)classfile -> classfile.isClassfile()).withFilter((Function1 & Serializable)classfile -> query.matches(classfile.fullname())).map((Function1 & Serializable)classfile -> classfile, ClassTag$.MODULE$.apply(Classfile.class)));
        });
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface Indexer {
        public static Indexer default() {
            return ClasspathSearch$Indexer$.MODULE$.default();
        }

        public ClasspathSearch index(Seq<Path> var1, ExcludedPackagesHandler var2, int var3);

        public static int index$default$3$(Indexer $this) {
            return $this.index$default$3();
        }

        default public int index$default$3() {
            return CompressedPackageIndex$.MODULE$.DefaultBucketSize();
        }
    }
}

