/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.util.Comparator;
import scala.Char$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.meta.internal.metals.Classfile;
import scala.meta.internal.metals.Fuzzy$;

public class ClassfileComparator
implements Comparator<Classfile> {
    private final String query;

    public ClassfileComparator(String query) {
        this.query = query;
    }

    public int characterCount(String string, char ch) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int compare(Classfile o1, Classfile o2) {
        int byNameLength = Integer.compare(Fuzzy$.MODULE$.nameLength(o1.filename()), Fuzzy$.MODULE$.nameLength(o2.filename()));
        if (byNameLength != 0) {
            return byNameLength;
        }
        int byInnerclassDepth = Integer.compare(this.characterCount(o1.filename(), '$'), this.characterCount(o2.filename(), '$'));
        if (byInnerclassDepth != 0) {
            return byInnerclassDepth;
        }
        int byFirstQueryCharacter = Integer.compare(o1.filename().indexOf(Char$.MODULE$.char2int(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(this.query)))), o2.filename().indexOf(Char$.MODULE$.char2int(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(this.query)))));
        if (byFirstQueryCharacter != 0) {
            return byFirstQueryCharacter;
        }
        int byPackageDepth = Integer.compare(this.characterCount(o1.pkg(), '/'), this.characterCount(o2.pkg(), '/'));
        if (byPackageDepth != 0) {
            return byPackageDepth;
        }
        return o1.filename().compareTo(o2.filename());
    }
}

