/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pc;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContextExecutor;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.Reporter;
import scala.meta.internal.mtags.CommonMtagsEnrichments;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.meta.internal.pc.CompilerJobQueue;
import scala.meta.internal.pc.CompilerJobQueue$;
import scala.meta.internal.pc.CompilerThrowable$;
import scala.meta.internal.pc.CompilerWrapper;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.pc.CancelToken;
import scala.meta.pc.PresentationCompilerConfig;
import scala.meta.pc.VirtualFileParams;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class CompilerAccess<Reporter, Compiler> {
    private final PresentationCompilerConfig config;
    private final Option<ScheduledExecutorService> sh;
    private final Function0<CompilerWrapper<Reporter, Compiler>> newCompiler;
    private final boolean shouldResetJobQueue;
    private final Function0<String> additionalReportingData;
    private final ExecutionContextExecutor ec;
    private final ReportContext rc;
    private final Logger logger;
    private final CompilerJobQueue jobs;
    private CompilerWrapper<Reporter, Compiler> _compiler;

    public CompilerAccess(PresentationCompilerConfig config, Option<ScheduledExecutorService> sh, Function0<CompilerWrapper<Reporter, Compiler>> newCompiler, boolean shouldResetJobQueue, Function0<String> additionalReportingData, ExecutionContextExecutor ec, ReportContext rc) {
        this.config = config;
        this.sh = sh;
        this.newCompiler = newCompiler;
        this.shouldResetJobQueue = shouldResetJobQueue;
        this.additionalReportingData = additionalReportingData;
        this.ec = ec;
        this.rc = rc;
        this.logger = Logger.getLogger(CompilerAccess.class.getName());
        this.jobs = CompilerJobQueue$.MODULE$.apply();
    }

    public CompilerAccess(PresentationCompilerConfig config, Option<ScheduledExecutorService> sh, Function0<CompilerWrapper<Reporter, Compiler>> newCompiler, boolean shouldResetJobQueue, ExecutionContextExecutor ec, ReportContext rc) {
        this(config, sh, newCompiler, shouldResetJobQueue, CompilerAccess.CompilerAccess$superArg$1(config, sh, newCompiler, shouldResetJobQueue, ec, rc), ec, rc);
    }

    private boolean isEmpty() {
        return this._compiler == null;
    }

    private boolean isDefined() {
        return !this.isEmpty();
    }

    private CompilerWrapper<Reporter, Compiler> loadCompiler() {
        if (this._compiler == null) {
            this._compiler = (CompilerWrapper)this.newCompiler.apply();
        }
        this._compiler.resetReporter();
        return this._compiler;
    }

    public abstract Reporter newReporter();

    public Reporter reporter() {
        if (this.isEmpty()) {
            return this.newReporter();
        }
        return this._compiler.reporterAccess().reporter();
    }

    public boolean isLoaded() {
        return this._compiler != null;
    }

    public void shutdown() {
        this.shutdownCurrentCompiler();
        this.jobs.shutdown();
    }

    public void shutdownCurrentCompiler() {
        CompilerWrapper compiler = this._compiler;
        if (compiler != null) {
            compiler.askShutdown();
            this._compiler = null;
            this.sh.foreach((Function1 & Serializable)scheduler -> scheduler.schedule(() -> {
                if (compiler.isAlive()) {
                    compiler.stop();
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }, 2L, TimeUnit.SECONDS));
            return;
        }
    }

    public <T> CompletableFuture<T> withInterruptableCompiler(Option<VirtualFileParams> params, T t, CancelToken token, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk) {
        AtomicBoolean isFinished = new AtomicBoolean(false);
        ObjectRef queueThread = ObjectRef.create((Object)Option$.MODULE$.empty());
        CompletableFuture<T> result = this.onCompilerJobQueue((Function0 & Serializable)() -> {
            Object object;
            queueThread$1.elem = Some$.MODULE$.apply((Object)Thread.currentThread());
            try {
                object = this.withSharedCompiler(params, t, thunk);
            }
            finally {
                isFinished.set(true);
            }
            return object;
        }, token);
        token.onCancel().whenCompleteAsync((isCancelled, _$2) -> ((Option)queueThread$2.elem).foreach((Function1)(JProcedure1 & Serializable)thread -> {
            if (Predef$.MODULE$.Boolean2boolean(isCancelled) && isFinished.compareAndSet(false, true) && this.isDefined()) {
                Option<Thread> option = this._compiler.presentationCompilerThread();
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                if (option instanceof Some) {
                    Thread pcThread = (Thread)((Some)option).value();
                    pcThread.interrupt();
                    Thread thread2 = thread;
                    Thread thread3 = pcThread;
                    if (thread2 == null ? thread3 != null : !thread2.equals(thread3)) {
                        thread.interrupt();
                        return;
                    }
                    return;
                }
                throw new MatchError(option);
            }
        }), (Executor)this.ec);
        return result;
    }

    public <T> CompletableFuture<T> withNonInterruptableCompiler(Option<VirtualFileParams> params, T t, CancelToken token, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk) {
        return this.onCompilerJobQueue((Function0 & Serializable)() -> this.withSharedCompiler(params, t, thunk), token);
    }

    public <T> T withSharedCompiler(Option<VirtualFileParams> params, T t, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk) {
        Object object;
        try {
            object = thunk.apply(this.loadCompiler());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null && InterruptException$.MODULE$.unapply(throwable2)) {
                object = t;
            }
            if (throwable2 != null) {
                Throwable other = throwable2;
                object = this.handleSharedCompilerException(other).map((Function1 & Serializable)message -> this.retryWithCleanCompiler(params, thunk, t, (String)message)).getOrElse(() -> this.withSharedCompiler$$anonfun$2(other, params, t));
            }
            throw throwable;
        }
        return (T)object;
    }

    public abstract Option<String> handleSharedCompilerException(Throwable var1);

    public abstract boolean ignoreException(Throwable var1);

    private <T> T retryWithCleanCompiler(Option<VirtualFileParams> params, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk, T t, String cause) {
        Object object;
        this.shutdownCurrentCompiler();
        this.logger.log(Level.INFO, new StringBuilder(62).append("compiler crashed due to ").append(cause).append(", retrying with new compiler instance.").toString());
        try {
            object = thunk.apply(this.loadCompiler());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                if (InterruptException$.MODULE$.unapply(throwable2)) {
                    object = t;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.handleError(e, params);
                    object = t;
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    private void handleError(Throwable e, Option<VirtualFileParams> params) {
        Throwable error = CompilerThrowable$.MODULE$.trimStackTrace(e);
        Report report = Report$.MODULE$.apply("compiler-error", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(191).append("|occurred in the presentation compiler.\n            |\n            |presentation compiler configuration:\n            |").append(this.additionalReportingData.apply()).append("\n            |\n            |action parameters:\n            |").append(params.map((Function1 & Serializable)_$3 -> {
            CommonMtagsEnrichments.XtensionVirtualFileParams xtensionVirtualFileParams = CommonMtagsEnrichments$.MODULE$.XtensionVirtualFileParams((VirtualFileParams)_$3);
            return xtensionVirtualFileParams.printed(xtensionVirtualFileParams.printed$default$1());
        }).getOrElse(CompilerAccess::$anonfun$3)).append("\n            |").toString())), error, (Option<String>)params.map((Function1 & Serializable)_$4 -> _$4.uri().toString()));
        Reporter reporter = this.rc.unsanitized();
        Option<Path> pathToReport = reporter.create((Function0<Report>)((Function0 & Serializable)() -> CompilerAccess.$anonfun$5(report)), reporter.create$default$2());
        Option<Path> option = pathToReport;
        if (option instanceof Some) {
            Path path = (Path)((Some)option).value();
            this.logger.log(Level.SEVERE, new StringBuilder(93).append("A severe compiler error occurred, full details of the error can be found in the error report ").append(path).toString());
        } else {
            this.logger.log(Level.SEVERE, error.getMessage(), error);
        }
        this.shutdownCurrentCompiler();
    }

    private <T> CompletableFuture<T> onCompilerJobQueue(Function0<T> thunk, CancelToken token) {
        CompletableFuture result = new CompletableFuture();
        this.jobs.submit(result, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            token.checkCanceled();
            Thread.interrupted();
            result.complete(thunk.apply());
        });
        token.onCancel().whenCompleteAsync((isCancelled, _$5) -> {
            if (Predef$.MODULE$.Boolean2boolean(isCancelled) && !result.isDone()) {
                result.cancel(false);
                return;
            }
        }, (Executor)this.ec);
        this.sh.foreach((Function1 & Serializable)scheduler -> scheduler.schedule(() -> {
            if (!result.isDone()) {
                BoxedUnit boxedUnit;
                try {
                    if (this.shouldResetJobQueue) {
                        this.jobs.reset();
                    }
                    result.cancel(false);
                    this.shutdownCurrentCompiler();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                    } else if (throwable2 != null) {
                        Throwable other = throwable2;
                        if (!this.ignoreException(other)) {
                            throw other;
                        }
                    } else {
                        throw throwable;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            return BoxedUnit.UNIT;
        }, this.config.timeoutDelay(), this.config.timeoutUnit()));
        return result;
    }

    private static <Reporter, Compiler> Function0<String> CompilerAccess$superArg$1(PresentationCompilerConfig config, Option<ScheduledExecutorService> sh, Function0<CompilerWrapper<Reporter, Compiler>> newCompiler, boolean shouldResetJobQueue, ExecutionContextExecutor ec, ReportContext rc) {
        return (Function0 & Serializable)() -> "";
    }

    private final Object withSharedCompiler$$anonfun$2(Throwable other$1, Option params$4, Object default$4) {
        this.handleError(other$1, (Option<VirtualFileParams>)params$4);
        return default$4;
    }

    private static final String $anonfun$3() {
        return "<NONE>";
    }

    private static final Report $anonfun$5(Report report$1) {
        return report$1;
    }
}

