/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.pc;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.interactive.Interactive$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.Spans;
import dotty.tools.pc.utils.MtagsEnrichments$;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.meta.pc.OffsetParams;
import scala.runtime.LazyRef;
import scala.runtime.Scala3RunTime$;

public class SelectionRangeProvider {
    private final InteractiveDriver driver;
    private final java.util.List<OffsetParams> params;

    public SelectionRangeProvider(InteractiveDriver driver, java.util.List<OffsetParams> params) {
        this.driver = driver;
        this.params = params;
    }

    public List<SelectionRange> selectionRange() {
        LazyRef lazyRef = new LazyRef();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.params).asScala().toList().map((Function1 & Serializable)param -> {
            URI x$proxy1 = param.uri();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            URI uri = x$proxy1;
            String x$proxy2 = param.text();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            String text = x$proxy2;
            Path filePath = Paths.get(uri);
            SourceFile source = SourceFile$.MODULE$.virtual(filePath.toString(), text, SourceFile$.MODULE$.virtual$default$3());
            this.driver.run(uri, source);
            SourcePosition pos = MtagsEnrichments$.MODULE$.sourcePosition(this.driver, (OffsetParams)param, MtagsEnrichments$.MODULE$.sourcePosition$default$3(this.driver));
            List path = Interactive$.MODULE$.pathTo((List)this.driver.openedTrees().apply((Object)uri), pos, this.ctx$1(lazyRef));
            List bareRanges = path.map((Function1 & Serializable)tree -> {
                SelectionRange selectionRange = new SelectionRange();
                selectionRange.setRange(MtagsEnrichments$.MODULE$.toLsp(tree.sourcePos(this.ctx$1(lazyRef))));
                return selectionRange;
            });
            List comments = (List)this.driver.compilationUnits().get((Object)uri).map((Function1 & Serializable)_$1 -> _$1.comments()).toList().flatten(Predef$.MODULE$.$conforms());
            List commentRanges = comments.find((Function1 & Serializable)_$2 -> Spans.Span$.MODULE$.contains$extension(_$2.span(), pos.span())).map((Function1 & Serializable)comment -> {
                int startLine = source.offsetToLine(Spans.Span$.MODULE$.start$extension(comment.span()));
                int endLine = source.offsetToLine(Spans.Span$.MODULE$.end$extension(comment.span()));
                int startChar = source.column(Spans.Span$.MODULE$.start$extension(comment.span()));
                int endChar = source.column(Spans.Span$.MODULE$.end$extension(comment.span()));
                return new SelectionRange(startLine, startChar, endLine, endChar){
                    {
                        this.setRange(new Range(new Position(startLine$1, startChar$1), new Position(endLine$1, endChar$1)));
                    }
                };
            }).toList();
            return (SelectionRange)((IterableOnceOps)commentRanges.$plus$plus((IterableOnce)bareRanges)).reduceRightOption((Function2 & Serializable)(child, parent) -> this.setParent((SelectionRange)child, (SelectionRange)parent)).getOrElse(SelectionRangeProvider::selectionRange$$anonfun$1$$anonfun$2);
        });
    }

    private SelectionRange setParent(SelectionRange child, SelectionRange parent) {
        Range range = child.getRange();
        Range range2 = parent.getRange();
        if (!(range != null ? !range.equals(range2) : range2 != null)) {
            return parent;
        }
        child.setParent(parent);
        return child;
    }

    private final Contexts.Context ctx$lzyINIT1$1(LazyRef ctx$lzy1$1) {
        Contexts.Context context;
        LazyRef lazyRef = ctx$lzy1$1;
        synchronized (lazyRef) {
            context = (Contexts.Context)(ctx$lzy1$1.initialized() ? ctx$lzy1$1.value() : ctx$lzy1$1.initialize((Object)this.driver.currentCtx()));
        }
        return context;
    }

    private final Contexts.Context ctx$1(LazyRef ctx$lzy1$2) {
        return (Contexts.Context)(ctx$lzy1$2.initialized() ? ctx$lzy1$2.value() : this.ctx$lzyINIT1$1(ctx$lzy1$2));
    }

    private static final SelectionRange selectionRange$$anonfun$1$$anonfun$2() {
        return new SelectionRange();
    }
}

