/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.pc;

import dotty.tools.dotc.core.tasty.TastyHTMLPrinter;
import dotty.tools.dotc.core.tasty.TastyPrinter;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.HtmlBuilder$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class TastyUtils$
implements Serializable {
    private static final String standaloneHtmlStyles;
    private static final String htmlStyles;
    public static final TastyUtils$ MODULE$;

    private TastyUtils$() {
    }

    static {
        MODULE$ = new TastyUtils$();
        standaloneHtmlStyles = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<style>\n       |  body {\n       |    background-color: #212529;\n       |    color: wheat;\n       |    padding: 1em;\n       |    margin: 0;\n       |    font-size: 14px;\n       |  }\n       |</style>\n       |"));
        htmlStyles = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<style>\n       |  span.name {\n       |    color: magenta;\n       |  }\n       |  span.tree {\n       |    color: yellow;\n       |  }\n       |  span.length {\n       |    color: cyan;\n       |  }\n       |</style>\n       |"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TastyUtils$.class);
    }

    public String getTasty(URI tastyURI, boolean isHttpEnabled) {
        if (isHttpEnabled) {
            return this.getStandaloneHtmlTasty(tastyURI);
        }
        return this.normalTasty(tastyURI);
    }

    public String getStandaloneHtmlTasty(URI tastyURI) {
        return this.htmlTasty(tastyURI, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{standaloneHtmlStyles}))), this.htmlTasty$default$3());
    }

    private String normalTasty(URI tastyURI) {
        byte[] tastyBytes = Files.readAllBytes(Paths.get(tastyURI));
        if (tastyBytes == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return new TastyPrinter(tastyBytes).showContents();
    }

    private String htmlTasty(URI tastyURI, List<String> headElems, String bodyAttributes) {
        String title = this.tastyHtmlPageTitle(tastyURI);
        byte[] tastyBytes = Files.readAllBytes(Paths.get(tastyURI));
        if (tastyBytes == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        String tastyHtml = new TastyHTMLPrinter(tastyBytes).showContents();
        return HtmlBuilder$.MODULE$.apply().page(title, (List<String>)headElems.$colon$colon((Object)htmlStyles), bodyAttributes, (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)builder -> builder.element("pre", "class='container is-dark'", (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> _$1.raw(tastyHtml))).render();
    }

    private List<String> htmlTasty$default$2() {
        return package$.MODULE$.Nil();
    }

    private String htmlTasty$default$3() {
        return "";
    }

    private String tastyHtmlPageTitle(URI file) {
        Path x$proxy1 = Paths.get(file);
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        String filename = x$proxy1.getFileName().toString();
        return new StringBuilder(10).append("TASTy for ").append(filename).toString();
    }
}

