/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.Report$;
import scala.meta.internal.metals.ReportFileName$;
import scala.meta.internal.metals.ReportLevel;
import scala.meta.internal.metals.Reporter;
import scala.meta.internal.metals.StdReportContext$;
import scala.meta.internal.metals.TimeFormatter$;
import scala.meta.internal.metals.utils.LimitedFilesManager;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public class StdReporter
implements Reporter {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(StdReporter.class.getDeclaredField("userHome$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StdReporter.class.getDeclaredField("reportsDir$lzy1"));
    private final Path workspace;
    private final Function1<Option<String>, Option<String>> resolveBuildTarget;
    private final ReportLevel level;
    private final String name;
    private final Path maybeReportsDir;
    private volatile Object reportsDir$lzy1;
    private final LimitedFilesManager limitedFilesManager;
    private volatile Object userHome$lzy1;
    private final AtomicBoolean initialized;
    private final AtomicReference<Map<String, Path>> reported;

    public StdReporter(Path workspace, Path pathToReports, Function1<Option<String>, Option<String>> resolveBuildTarget, ReportLevel level, String name) {
        this.workspace = workspace;
        this.resolveBuildTarget = resolveBuildTarget;
        this.level = level;
        this.name = name;
        this.maybeReportsDir = workspace.resolve(pathToReports).resolve(name);
        this.limitedFilesManager = new LimitedFilesManager(this.maybeReportsDir(), StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS(), ReportFileName$.MODULE$.pattern(), ".md");
        this.initialized = new AtomicBoolean(false);
        this.reported = new AtomicReference<Object>(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
    }

    @Override
    public String name() {
        return this.name;
    }

    public Path maybeReportsDir() {
        return this.maybeReportsDir;
    }

    private Path reportsDir() {
        Object object = this.reportsDir$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.reportsDir$lzyINIT1();
    }

    private Object reportsDir$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.reportsDir$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        path = CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(this.maybeReportsDir()).createDirectories();
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.reportsDir$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<String> userHome() {
        Object object = this.userHome$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.userHome$lzyINIT1();
    }

    private Object userHome$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.userHome$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = Option$.MODULE$.apply((Object)System.getProperty("user.home"));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.userHome$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void readInIds() {
        Map reports = this.getReports().flatMap((Function1 & Serializable)report -> {
            java.util.List<String> lines = Files.readAllLines(report.file().toPath());
            if (lines.size() > 0) {
                String string = lines.get(0);
                String id = string;
                if (id.startsWith(Report$.MODULE$.idPrefix())) {
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(id), Report$.MODULE$.idPrefix()));
                    return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)report.toPath()));
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.reported.updateAndGet(_$5 -> (Map)_$5.$plus$plus((IterableOnce)reports));
    }

    @Override
    public Option<Path> create(Function0<Report> report, boolean ifVerbose) {
        if (ifVerbose && !this.level.isVerbose()) {
            return None$.MODULE$;
        }
        if (this.initialized.compareAndSet(false, true)) {
            this.readInIds();
        }
        Option sanitizedId = ((Report)report.apply()).id().map((Function1 & Serializable)text -> this.sanitize((String)text));
        Path path = this.reportPath((Report)report.apply());
        Option optDuplicate = sanitizedId.map((Function1 & Serializable)id -> {
            Map<String, Path> reportedMap = this.reported.getAndUpdate(map -> {
                if (map.contains(id)) {
                    return map;
                }
                String string = (String)Predef$.MODULE$.ArrowAssoc(id);
                return (Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)path));
            });
            return Tuple2$.MODULE$.apply(id, reportedMap);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Map reportedMap = (Map)tuple2._2();
                return reportedMap.get((Object)id).map((Function1 & Serializable)duplicate -> duplicate);
            }
            throw new MatchError((Object)tuple2);
        });
        return optDuplicate.orElse(() -> this.create$$anonfun$1(path, report));
    }

    @Override
    public boolean create$default$2() {
        return false;
    }

    @Override
    public String sanitize(String text) {
        String textAfterWokspaceReplace = text.replace(this.workspace.toString(), StdReportContext$.MODULE$.WORKSPACE_STR());
        return (String)this.userHome().map((Function1 & Serializable)_$6 -> textAfterWokspaceReplace.replace((CharSequence)_$6, StdReportContext$.MODULE$.HOME_STR())).getOrElse(() -> StdReporter.sanitize$$anonfun$2(textAfterWokspaceReplace));
    }

    private Path reportPath(Report report) {
        String date = TimeFormatter$.MODULE$.getDate();
        String time = TimeFormatter$.MODULE$.getTime();
        String buildTargetPart = (String)((Option)this.resolveBuildTarget.apply(report.path())).map((Function1 & Serializable)_$7 -> StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("_("), _$7)), ")")).getOrElse(StdReporter::$anonfun$7);
        String filename = new StringBuilder(6).append("r_").append(report.name()).append(buildTargetPart).append("_").append(time).append(".md").toString();
        return this.reportsDir().resolve(date).resolve(filename);
    }

    @Override
    public List<TimestampedFile> cleanUpOldReports(int maxReportsNumber) {
        return this.limitedFilesManager.deleteOld(maxReportsNumber);
    }

    @Override
    public int cleanUpOldReports$default$1() {
        return StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS();
    }

    @Override
    public List<TimestampedFile> getReports() {
        return this.limitedFilesManager.getAllFiles();
    }

    @Override
    public void deleteAll() {
        this.getReports().foreach((Function1)(JProcedure1 & Serializable)r -> Files.delete(r.toPath()));
        this.limitedFilesManager.directoriesWithDate().foreach((Function1)(JProcedure1 & Serializable)d -> Files.delete(d.toPath()));
    }

    private final Path create$$anonfun$1$$anonfun$1(Path path$5, Function0 report$2) {
        CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path$5).createDirectories();
        CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path$5).writeText(this.sanitize(((Report)report$2.apply()).fullText(true)));
        return path$5;
    }

    private final Option create$$anonfun$1(Path path$4, Function0 report$1) {
        return Try$.MODULE$.apply(() -> this.create$$anonfun$1$$anonfun$1(path$4, report$1)).toOption();
    }

    private static final String sanitize$$anonfun$2(String textAfterWokspaceReplace$2) {
        return textAfterWokspaceReplace$2;
    }

    private static final String $anonfun$7() {
        return "";
    }
}

