/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.meta.internal.metals.ExactCharSequence;
import scala.meta.internal.metals.ExactCharSequence$;
import scala.meta.internal.metals.StringBloomFilter;
import scala.meta.internal.metals.TrigramSubstrings$;
import scala.meta.internal.metals.ZeroCopySubSequence;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Fuzzy {
    private final int ExactSearchLimit;

    public Fuzzy() {
        this.ExactSearchLimit = 3;
    }

    public boolean matches(CharSequence query, CharSequence symbol, int skipNames) {
        int li = this.lastIndex(symbol);
        return this.loopDelimiters$1(query, symbol, li, query.length(), this.lastIndex(symbol), 0, skipNames);
    }

    public int matches$default$3() {
        return 0;
    }

    private boolean exactMatch(CharSequence query, CharSequence symbol, int sa, int sb) {
        if (query.length() == sb - sa) {
            for (int idx = 0; idx < query.length(); ++idx) {
                if (query.charAt(idx) == symbol.charAt(sa + idx)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isExactMatch(String query, CharSequence filename) {
        int sb = this.lastIndex(filename);
        int sa = sb - query.length();
        if (sa < 0) {
            return false;
        }
        return this.exactMatch(query, filename, sa, sb);
    }

    private int lastIndex(CharSequence symbol) {
        int end;
        for (end = symbol.length() - (this.endsWith(symbol, ".class") ? ".class".length() : 1); end >= 0 && this.isDelimiter(symbol.charAt(end)); --end) {
        }
        return end + 1;
    }

    public boolean isDelimiter(char ch) {
        char c = ch;
        switch (c) {
            case '#': 
            case '$': 
            case '.': 
            case '/': {
                return true;
            }
        }
        return false;
    }

    public int nameLength(CharSequence symbol) {
        int end;
        int start;
        for (start = end = this.lastIndex(symbol) - 1; start >= 0 && !this.isDelimiter(symbol.charAt(start)); --start) {
        }
        if (start < 0) {
            return end + 1;
        }
        return end - start;
    }

    public boolean endsWith(CharSequence cs, String string) {
        int a = cs.length() - 1;
        int b = string.length() - 1;
        if (b > a) {
            return false;
        }
        if (b == 0) {
            return false;
        }
        for (int i = 0; i <= a && i <= b; ++i) {
            if (cs.charAt(a - i) == string.charAt(b - i)) continue;
            return false;
        }
        return true;
    }

    private Delimiter lastDelimiter(CharSequence string, int fromIndex) {
        int curr = fromIndex - 2;
        boolean bl = true;
        while (curr >= 0 && bl) {
            if (this.isDelimiter(string.charAt(curr))) {
                bl = false;
                continue;
            }
            --curr;
        }
        if (curr < 0) {
            return new Delimiter(true, 0);
        }
        return new Delimiter(false, curr + 1);
    }

    private boolean matchesName(CharSequence query, int qa, int qb, CharSequence symbol, int sa, int sb) {
        return Fuzzy.loop$1(query, qb, symbol, sb, qa, -1, sa, -1);
    }

    public StringBloomFilter bloomFilterSymbolStrings(Iterable<String> symbols) {
        int estimatedSize = BoxesRunTime.unboxToInt((Object)symbols.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> Fuzzy.$anonfun$1(BoxesRunTime.unboxToInt((Object)x$1), (String)x$2)));
        StringBloomFilter hasher = new StringBloomFilter(estimatedSize);
        this.bloomFilterSymbolStrings(symbols, hasher);
        return hasher;
    }

    public void bloomFilterSymbolStrings(String symbol, StringBloomFilter hasher) {
        int i;
        if (symbol.endsWith("$sp.class")) {
            return;
        }
        hasher.reset();
        int delimiter = i = 0;
        StringBuilder upper = new StringBuilder();
        int symbolicDelimiter = i;
        int N = this.lastIndex(symbol);
        while (i < N) {
            char ch;
            char c = ch = symbol.charAt(i);
            switch (c) {
                case '#': 
                case '$': 
                case '.': 
                case '/': {
                    hasher.reset();
                    symbolicDelimiter = delimiter = i + 1;
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                default: {
                    if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(ch))) {
                        delimiter = i;
                        hasher.reset();
                        upper.append(ch);
                    }
                    Object object = BoxesRunTime.boxToBoolean((boolean)hasher.putCharIncrementally(ch));
                    break;
                }
            }
            ++i;
        }
        ZeroCopySubSequence lastName = new ZeroCopySubSequence(symbol, symbolicDelimiter, N);
        if (!symbol.endsWith("/") && !this.isAllNumeric(lastName) && lastName.length() < this.ExactSearchLimit()) {
            hasher.putCharSequence(ExactCharSequence$.MODULE$.apply(lastName));
        }
        TrigramSubstrings$.MODULE$.foreach(upper.toString(), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)trigram -> hasher.putCharSequence((CharSequence)trigram), TrigramSubstrings$.MODULE$.foreach$default$3());
    }

    public void bloomFilterSymbolStrings(Iterable<String> symbols, StringBloomFilter hasher) {
        symbols.foreach((Function1)(JProcedure1 & Serializable)sym -> this.bloomFilterSymbolStrings((String)sym, hasher));
    }

    public boolean isAllNumeric(CharSequence string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public int ExactSearchLimit() {
        return this.ExactSearchLimit;
    }

    public Iterable<CharSequence> bloomFilterQueryStrings(String query, boolean includeTrigrams) {
        if (query.length() < this.ExactSearchLimit()) {
            return (Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExactCharSequence[]{ExactCharSequence$.MODULE$.apply(query)}));
        }
        Set result = (Set)Set$.MODULE$.empty();
        StringBuilder upper = new StringBuilder();
        int border = 0;
        block6: for (int i = 0; i < query.length(); ++i) {
            char ch;
            char c = ch = query.charAt(i);
            switch (c) {
                case '#': 
                case '$': 
                case '.': 
                case '/': {
                    result.add((Object)new ZeroCopySubSequence(query, border, i));
                    border = i + 1;
                    continue block6;
                }
                default: {
                    if (!RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(ch))) continue block6;
                    if (border != i) {
                        ZeroCopySubSequence exactName = new ZeroCopySubSequence(query, border, i);
                        result.add((Object)exactName);
                    }
                    upper.append(ch);
                    border = i;
                    continue block6;
                }
            }
        }
        char c = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(query));
        switch (c) {
            case '#': 
            case '$': 
            case '.': 
            case '/': {
                Object object = BoxedUnit.UNIT;
                break;
            }
            default: {
                Object object = BoxesRunTime.boxToBoolean((boolean)result.add((Object)new ZeroCopySubSequence(query, border, query.length())));
                break;
            }
        }
        if (includeTrigrams) {
            TrigramSubstrings$.MODULE$.foreach(upper.toString(), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)trigram -> result.$plus$eq(trigram), TrigramSubstrings$.MODULE$.foreach$default$3());
        }
        return result;
    }

    public boolean bloomFilterQueryStrings$default$2() {
        return true;
    }

    public boolean matchesSubCharacters(CharSequence query, CharSequence sym) {
        int A = query.length();
        int B = sym.length();
        return Fuzzy.loop$2(query, sym, A, B, 0, 0);
    }

    private final boolean loopDelimiters$1(CharSequence query$1, CharSequence symbol$1, int li$1, int qb, int sb, int depth, int skip) {
        while (true) {
            Delimiter qd = this.lastDelimiter(query$1, qb);
            Delimiter sd = this.lastDelimiter(symbol$1, sb);
            if (skip > 0) {
                int n = sd.idx() - 1;
                int n2 = skip - 1;
                sb = n;
                skip = n2;
                continue;
            }
            boolean isMatch = this.matchesName(query$1, qd.idx(), qb, symbol$1, sd.idx(), sb);
            if (isMatch) {
                if (qd.isFinished()) {
                    return true;
                }
                if (sd.isFinished()) {
                    return false;
                }
                int n = qd.idx() - 1;
                int n3 = sd.idx() - 1;
                int n4 = depth + 1;
                int n5 = skip - 1;
                qb = n;
                sb = n3;
                depth = n4;
                skip = n5;
                continue;
            }
            if (sb == li$1 && this.exactMatch("package", symbol$1, sd.idx(), sb)) {
                sb = sd.idx() - 1;
                continue;
            }
            if (depth <= 0 || sd.isFinished()) break;
            int n = sd.idx() - 1;
            int n6 = skip - 1;
            sb = n;
            skip = n6;
        }
        return false;
    }

    private static final boolean loop$1(CharSequence query$2, int qb$1, CharSequence symbol$2, int sb$1, int qa, int ql, int sa, int sl) {
        while (qa < qb$1) {
            char ss;
            if (sa >= sb$1) {
                return false;
            }
            char qq = query$2.charAt(qa);
            if (qq == (ss = symbol$2.charAt(sa))) {
                int qll = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(qq)) ? qa : ql;
                int sll = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(ss)) ? sa : sl;
                int n = qa + 1;
                int n2 = qll;
                int n3 = sa + 1;
                int n4 = sll;
                qa = n;
                ql = n2;
                sa = n3;
                sl = n4;
                continue;
            }
            if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(qq))) {
                if (sl < 0 || ql < 0) {
                    return false;
                }
                int n = ql;
                int n5 = -1;
                int n6 = sl + 1;
                int n7 = -1;
                qa = n;
                ql = n5;
                sa = n6;
                sl = n7;
                continue;
            }
            ++sa;
        }
        return true;
    }

    private static final /* synthetic */ int $anonfun$1(int x$1, String x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int accum = BoxesRunTime.unboxToInt((Object)tuple2._1());
            String string = (String)tuple2._2();
            int redundantSuffix = string.endsWith(".class") ? ".class".length() : 0;
            int uppercases = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(string), (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1))));
            return accum + string.length() + TrigramSubstrings$.MODULE$.trigramCombinations(uppercases) - redundantSuffix;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean loop$2(CharSequence query$3, CharSequence sym$1, int A$1, int B$1, int a, int b) {
        while (a < A$1) {
            char cb;
            if (b >= B$1) {
                return false;
            }
            char ca = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(query$3.charAt(a)));
            if (ca == (cb = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(sym$1.charAt(b))))) {
                int n = a + 1;
                int n2 = b + 1;
                a = n;
                b = n2;
                continue;
            }
            if (cb == '$') {
                return false;
            }
            ++b;
        }
        return true;
    }

    public class Delimiter {
        private final boolean isFinished;
        private final int idx;

        public Delimiter(boolean isFinished, int idx) {
            this.isFinished = isFinished;
            this.idx = idx;
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public int idx() {
            return this.idx;
        }
    }
}

